/*
	-intensity good?
	-speed maximum higher or lower?
	-modular kapseln?: öffentliche var. order send event?
	-welche rendermodes gibt es für videoplayer.. wieso welcher?
	-relative path video

	//wichtig:
	-kann man transperent adden?
	-funktioniert brightness?
	-funktioniert saturation?

	Connection
	-> unity unabhängig von kostüm frame rate#
	-> nicht abkacken!
	parallelisieren?
*/
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Video;

/*NETWORKING*/
using System.Net;					//IPAddress,..
using System.Net.Sockets; //TCP Listener,...
using System;



public class controller : MonoBehaviour {
	//state:
	private int 				state;
	/*
			0.:Ariplane-take-off
			1.:Flashbacks
			2.:Airplane-landing
	*/

//flashbacks:
	//constanten:
	private const int 	vid_count						=  2;		//We want 4 flashbacks

	private const float start_intensity 	  =  0.5f;
	private const float default_speed 			=  1.0f;
	private const float default_brightness 	= 50.0f;
	private const float default_saturation  = 50.0f;

//set size to vid_count!!!!
	//to store our momentary values:
	private float[] 			intensity					= new float[vid_count];		//[0 to 100]
	private float[] 			speed							= new float[vid_count];		//[0 to 10]  //maybe faster?
	private float[] 			brightness				= new float[vid_count];		//[0 to 100]
	private float[]				saturation				= new float[vid_count];		//[o to 100]

	private VideoPlayer[] video_player			= new VideoPlayer[vid_count];

	//SERVER:
	TcpListener server;
	TcpClient client;
	public bool connected;
	private NetworkStream stream;

	void Start () {
		initialize_videos();
		initialize_values();

		//servetr:
		initialize_server();
	}

//INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##
	private void initialize_values()
	{
		state=0;	//Ariplane-take-off
		for (int i=0; i<vid_count; i++)
		{
			intensity[i]	=	start_intensity;
			speed[i]			=	default_speed;
			brightness[i]	=	default_brightness;
			saturation[i]	=	default_saturation;
		}
	}

	private void initialize_videos()
	{
		//Get Main Camera
		GameObject camera = GameObject.Find("Main Camera");
		for (int i=0; i<vid_count; i++)
		{

			//Add Component to Main Camera:
			video_player[i] = camera.AddComponent<UnityEngine.Video.VideoPlayer>();

			//Select renderMode
			//video_player[i].renderMode = UnityEngine.Video.VideoRenderMode.CameraNearPlane;
			//video_player[i].renderMode = UnityEngine.Video.VideoRenderMode.RenderTexture;
			//video_player[i].renderMode = UnityEngine.Video.VideoRenderMode.MaterialOverride;

			//Set alpha(transperency)
			video_player[i].targetCameraAlpha = start_intensity;

			//Set video path absolute
			video_player[i].url = "/Users/Hagen/Documents/unity_projekte/video_2d_test/Assets/vid_"+i+".mp4";

			//Set videos looping
			video_player[i].isLooping = true;

			//Start videos
			video_player[i].Play();
		}
	}

	private void initialize_server()
	{
		int port=12345;
		IPAddress loc_IP=IPAddress.Parse("192.168.1.4");
		server= new TcpListener(loc_IP,port);
		client=null;
		connected=false;
		server.Start();
	}
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##INIT##


	void Update () {
		//Input
		update_server();
		update_keyboard();
		//Output
		//update_values();	//recover
		update_vid();
	}
//UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##UPDA##U
	private void update_values()
	{
		//Recover values slowly:
		float recover_factor= 500;
		for(int i=0; i<vid_count; i++)
		{
			speed[i]+=(default_speed-speed[i])/recover_factor;
			brightness[i]+=(default_brightness-brightness[i])/recover_factor;
			saturation[i]+=(default_saturation-saturation[i])/recover_factor;
		}
	}

	private void update_vid()
	{
		//Update VIDEO_values
		for (int i=0; i<vid_count; i++)
		{
			video_player[i].targetCameraAlpha = intensity[i];
			video_player[i].playbackSpeed			= speed[i];
		}
	}

	private void update_server()
	{
		/*
		always disconnecting costs time...
		https://msdn.microsoft.com/de-de/library/system.net.sockets.tcplistener(v=vs.110).aspx
		wenn kostüm abschmiert.. gibts probleme..
		-active... ?
		-available
		-connected
		..> werte auslesen und dann wissen mit welchem wir einen abbruch abfangen können..?
		ansonsten gibts keine alternative..(?)!
		*/
		Byte[] bytes= new Byte[256];
		if(server.Pending())																							//Client available?
		{
			client=server.AcceptTcpClient();																//Accept Client
			if(client!=null)																								//Client there?
			{
				int i;
				stream=client.GetStream();																		//get Stream
				if((i=stream.Read(bytes, 0, bytes.Length))!=0)								//read bytes
				{
					store_data(System.Text.Encoding.ASCII.GetString(bytes,0,i));
				}
			client.Close();
			}
		}
	}

	private void store_data(String data)
	{
		Debug.Log(" dtime:" + (Time.deltaTime));
		Debug.Log("data:"+ data);
		if(data.Length<=20)
		{
			for (int j=0; j<vid_count; j++)	//keine lange fehlermedlung
			{
				float val;
				if(float.TryParse(data.Split('_')[j], out val)) //wirklich float?
				{
					intensity[j]=(130.0f-val)/100; //mit oder ohne minus?
				}
			}
		}
	}

	private void update_keyboard()
	{
		//ALTERNATIVE: KEY-INPUT
		if(Input.GetKeyDown(KeyCode.DownArrow))
		{
			if(intensity[0]>0)
			{
				intensity[0]-=0.1f;
			}
		}

		if(Input.GetKeyDown(KeyCode.UpArrow))
		{
			if(intensity[0]<1)
			{
				intensity[0]+=0.1f;
			}
		}

		if (Input.GetKeyDown(KeyCode.LeftArrow))
		{
			if(intensity[1]>0)
			{
				intensity[1]-=0.1f;
			}
		}
		if (Input.GetKeyDown(KeyCode.RightArrow))
		{
			if(intensity[1]<1)
			{
				intensity[1]+=0.1f;
			}
		}
		if (Input.GetKeyDown(KeyCode.T))
		{
			if(speed[0]<10)
			{
				speed[0]+=0.1f;
			}
		}
		if (Input.GetKeyDown(KeyCode.R))
		{
			if(speed[0]>0)
			{
				speed[0]-=0.1f;
			}
		}
		if (Input.GetKeyDown(KeyCode.G))
		{
			if(speed[1]<10)
			{
				Debug.Log(speed[1]);
				speed[1]+=0.1f;
			}
		}
		if (Input.GetKeyDown(KeyCode.F))
		{
			if(speed[1]>0)
			{
				speed[1]-=0.1f;
			}
		}
	}
}
