//programm_specific
#include <string>                   //to use string
#include <string.h>                 //comp
//Configure WIFI:
#include <ESP8266WiFi.h>            //Wifi-li brary
#include <SoftwareSerial.h>
#define baud 9600



//********************************************************
//********************  WLAN-Config  *********************
//********************************************************
const char* ssid     = "NAME OF WLAN";                    //Your WIFI Name
const char* password = "PASSWORD";                        //WIFI Password
//********************************************************


//********************************************************
//*******************  Host&Client  **********************
//********************************************************
WiFiClient client;                                        //Feather as a client
const char* host = "YOUR IP";                             //My Server IP Adress
const int httpPort = PORT;                               //Servers port
String msgi;
//********************************************************


//********************************************************
//*******************  Sensor  ***************************
//********************************************************
int vid_count = 4;
int signal_strength[] = {-1, -1, -1, -1};
float sensor_0[] = {-1, -1, -1, -1};
float sensor_1[] = {-1, -1, -1, -1};
float sensor_2[] = {-1, -1, -1, -1};
//********************************************************


//********************************************************
//*********************  BLE   ***************************
//********************************************************
SoftwareSerial mySerial(12, 14);
int ini, ini1, ini2, ini3, ini4, i = 1;
String data[4] = {"-1", "-1", "-1", "-1"}, msg;
boolean foundpos;
//********************************************************


//--------------------------------------------------------
//                     SETUP
//--------------------------------------------------------
void setup() {
  Serial.begin(baud);
  mySerial.begin(baud);

  start_wlan();                         //Connect to Server

  while(!mySerial.available()){         //Spam until response
    mySerial.write("AT");
    delay(100);
  }

  at();                                //Configure BLE-module
  delay(1000);
}
//--------------------------------------------------------


//--------------------------------------------------------
//                      LOOP
//--------------------------------------------------------
void loop() {
  parse_to_send();                    //Get data ready
  delay(150);
  send_via_wlan();                    //Send data to server
}
//--------------------------------------------------------

//--------------------------------------------------------
//                CONNECT TO SERVER
//--------------------------------------------------------
void start_wlan() {
  // We start by connecting to a WiFi network:
  Serial.flush();
  Serial.write("\r\n");
  Serial.print("\n Connecting to SSID: ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  //We are connected to SSID
  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}
//--------------------------------------------------------


//--------------------------------------------------------
//                 MANIPUULATE DATA
//--------------------------------------------------------
void manip_val() {
  for (int i; i < 4; i++){
    //signal_strength[i]=(((i+1)*signal_strength[i]+5)%100);
    signal_strength[i] = data[i].toFloat();
    //sensor_0[i]=random();
    //sensor_1[i]=;
    //sensor_2[i]=
  }
}
//--------------------------------------------------------


//--------------------------------------------------------
//                    SEND TO SERVER
//--------------------------------------------------------
void send_via_wlan() {
  if (!client.connected()){
    if (!client.connect(host, httpPort)){
      Serial.println("connection failed");
      delay(500);
    }
  }

  else {
    //Get data read to send
    msgi = "";
    for (int i = 0; i < vid_count; i++){
      msgi += String(data[i]);
      msgi += '_';
    }

    msgi += "\n\r";
    Serial.println(msgi);
    client.print(msgi);                      //SEND to Server
  }
}
//--------------------------------------------------------


//--------------------------------------------------------
//                RETRIEVE WANTED DATA
//--------------------------------------------------------
void parse_to_send() {
  mySerial.write("AT+DISI?");

  if (mySerial.available()) {

    msg = mySerial.readString();
    String tmp[4]={msg, msg ,msg, msg};


    ini = tmp[0].indexOf("MAC:-");
    data[0] = tmp[0].substring(ini+6, ini + 9);

    ini = tmp[1].indexOf("MAC:-");
    data[1] = tmp[1].substring(ini+6, ini + 9);

    ini = tmp[2].indexOf('MAC:-');
    data[2] = tmp[2].substring(ini+6, ini + 9)

    ini = tmp[3].indexOf('MAC:-');
    data[3] = tmp[3].substring(ini+6, ini + 9);
  }
}
//--------------------------------------------------------


//--------------------------------------------------------
//                 CONFIGURE BLE-module
//--------------------------------------------------------
void at() {
  mySerial.write("AT");
  if(mySerial.available()){
    Serial.write("AT...\n");
  }

  mySerial.write("AT+ROLE1");
  if(mySerial.available()){
    Serial.write("AT+ROLE1...\n");
  }

  mySerial.write("AT+BAUD0");
  if(mySerial.available()){
     Serial.write("AT+BAUD0...\n");
   }

  mySerial.write("AT+RESET");
  if(mySerial.available()){
    Serial.write("AT+RESET...\n");
  }

  mySerial.write("AT+SHOW1");
  if(mySerial.available()){
    Serial.write("AT+SHOW1...\n");
  }

  mySerial.write("AT+IMME1");
  if(mySerial.available()){
    Serial.write("AT+IMME1...\n");
  }
}
//--------------------------------------------------------
