import java.util.*;

//##########################_ARDUNIO_##########################
float buttonX;
float buttonY;
import processing.serial.*;
Serial xbee;
double msg_count;
String potVal;
float clr;

void serialEvent(Serial xbee) {
  Random generator;
  generator = new Random();

  potVal = xbee.readStringUntil(10);         // read incommung String

  if (potVal != null) {                       // not null
    println(msg_count+" Incoming data: " + potVal);
    buttonX=width*generator.nextFloat();     //UPDATE DESTINATION
    buttonY=height*generator.nextFloat();    //UPDATE DESTINATION

    msg_count++;
    //clr=(clr+10)%255;
  }
}
//#############################################################

//PPPPPPPPPPPPPPPPPPPPPPPPOOOOOOOOOOOOOOOOOOOOOOOOOOOOIIIIIIIIIIIIIIIIIIIIIIIIIIIIIINNNNNNNNNNNNNNT
class Point
{
  float x;
  float y;
  Point(float x_in, float y_in)
  {
    x=x_in;
    y=y_in;
  }
}

//EEEEEEEEEEENNNNNNNNNNNNNNNNNNNNNNNNNTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTIIIIIIIIIIIIIIIITTTTTTTTTTTY
public class Entity
{
  public Point pos;
  public Point vel;
  public Point acc;
  public Random generator;

  //CONSTRUCTOR
  Entity(Point pos_in, Point vel_in, Point acc_in)
  {
    pos=pos_in;
    vel=vel_in;
    acc=acc_in;
    generator= new Random();
  }
  //FUNKTIOENEN
  void update(boolean player)
  {
    check_values();
    //Update Position:
    pos.x+=max_vel*vel.x;
    pos.y+=max_vel*vel.y;
    //Update Velocity:
    vel.x+=max_acc*acc.x; 
    vel.y+=max_acc*acc.y; 
    //Update Acceleration:  (Im Durchschnitt acc um 0.. überlauf aber denkbar-..!)
    acc.x+=max_noise*(2*generator.nextFloat()-1);
    acc.y+=max_noise*(2*generator.nextFloat()-1);
    //Draw:
    if (player)
    {
      fill(  255*0.75, 255*abs(vel.x+vel.y)/2, 255*0.75);
      stroke(255*0.25, 255*0.25, 255*abs(acc.x+acc.y)/2);
    } else {
      fill(  255*0.25, 255*abs(vel.x+vel.y)/2, 255*0.25);
      stroke(255*0.25, 255*0.25, 255*abs(acc.x+acc.y)/2);
    }
    //point(pos.x, pos.y);  
    ellipse(pos.x, pos.y, 10, 10);
  }

  void check_values()
  {
    //Please don't leave!:
    if ((pos.x<0.0f) || (pos.x>width))
    {
      vel.x=vel.x*-1;
      acc.x=acc.x*-1;
    }
    if ((pos.y<0.0f) || (pos.y>height))
    {
      vel.y=vel.y*-1;
      acc.y=acc.y*-1;
    }
    //Please no speed of light!:   
    if ((vel.x>1)||(vel.x<-1))
    {
      acc.x=0;
      vel.x=vel.x/abs(vel.x);
    }
    if ((vel.y>1)||(vel.y<-1))
    {
      acc.y=0;
      vel.y=vel.y/abs(vel.y);
    }
  }

  Point get_point()
  {
    return pos;
  }
}

//SCEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEENNNNNNEEEEEEEEEEEEEEEEEEEE
class Scene
{  
  ArrayList<Entity> entitys;
  Random generator;
  Scene()
  {
    entitys= new ArrayList(); 
    generator = new Random();

    for (int i=0; i <max_entitys; i++)
    {
      entitys.add(generate());
    }
  }  

  Entity generate()  
  {
    Point pos=new Point(width*generator.nextFloat(), height*generator.nextFloat());
    Point vel=new Point(0*(2*generator.nextFloat()-1), 0*(2*generator.nextFloat()-1));
    Point acc=new Point(0, 0);//2*generator.nextFloat()-1,2*generator.nextFloat()-1);
    return new Entity(pos, vel, acc);
  }

  void update()
  {
    ListIterator<Entity> it1 = entitys.listIterator(0);

    //User:
    Entity e1=entitys.get(0);  //User

    float d_x=(e1.pos.x-buttonX);  //delta x
    float d_y=(e1.pos.y-buttonY);  //delta y
    /*
    float d_x=(e1.pos.x-mouseX);  //delta x
     float d_y=(e1.pos.y-mouseY);  //delta y
     */
    e1.acc.x-=d_x;
    e1.acc.y-=d_y;

    //All:
    for (int i=0; i<entitys.size(); i++)      //Update Loop
    {
      e1=it1.next();
      if (i==0)  
      {
        e1.update(true);  //User
      } else
      {
        e1.update(false);  //All The other
      }

      ListIterator<Entity> it2=entitys.listIterator(it1.previousIndex());
      it2.next();
      for (int j=i; j<entitys.size()-1; j++)     //Interaction Loop
      {

        Entity e2=it2.next();

        d_x=(e1.pos.x-e2.pos.x);
        d_y=(e1.pos.y-e2.pos.y);
        float delta=sqrt(pow(d_x, 2)+pow(d_y, 2));
        float min_radius=width/4;
        if ((delta)<=(min_radius))  //Close enough?
        {
          e1.acc.x-=magnet*d_x/abs(d_x)*(min_radius-abs(d_x));//1/magnet*(width/4)*delta/d_x;
          e2.acc.x+=magnet*d_x/abs(d_x)*(min_radius-abs(d_x));//1/magnet*(width/4)*delta/d_x;

          e1.acc.y-=magnet*d_y/abs(d_y)*(min_radius-abs(d_y));//1/magnet*(width/4)*delta/d_y;
          e2.acc.y+=magnet*d_y/abs(d_y)*(min_radius-abs(d_y));//1/magnet*(width/4)*delta/d_y;
        }
      }
    }
  }
}

//VAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAR
Scene world;
float max_vel=5;
float max_acc=0.0125;
float max_noise=0000.25;
float magnet=0.0005125;
float min_radius=width/2;
float user=20*magnet;
int max_entitys=4;

//SEEEEEEEEEEEEEEEEEEEEEEEEEEEETTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUP
void setup()
{
  fullScreen();
  smooth();
  //size(400, 400, P2D);
  background(0);
  //colorMode(HSB, 255);
  world = new Scene();
  //##########################_ARDUNIO_##########################
  //FIND PORT
  for (int i=0; i< Serial.list().length; i++)
  {
    println(i+": "+Serial.list()[i]);    //to find right port... for me 7 is list()[38]
  }

  //SELECT PORT manuelly
  xbee = new Serial(this, Serial.list()[38], 9600);
  msg_count=0;
  buttonX=width/2;
  buttonY=height/2;
  clr=0;
  //#############################################################
}

//DRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWWWWWWWWWWWWWWWWWWW
void draw()
{
  background(clr, clr, clr);
  noFill();
  noStroke(); 
  world.update();
}