var commands = '';
var turtle;
var step = 0;
var img;

function commandSetup() {
  
  //convert color to command
  
    var pRGBA;
    var pRGB = Array(3);
    var px;
    var py;
    var pCommand;
    
    loadPixels();

    for (var i = 0; i < pixels.length; i+=4) {
      //px = (i+width) % width;
      //py = i / height;
      //pRGBA = get(px, py);
      //pRGB = shorten(pRGBA);
      //pCommand = pRGB.indexOf(max(pRGB));
      
      //this method is much faster than using get(). note that I also changed the for loop (i+=4)
      //see https://p5js.org/reference/#/p5/pixels[] to understand the pixels[] array
      pRGB[0] = pixels[i];    //red
      pRGB[1] = pixels[i+1];  //green
      pRGB[2] = pixels[i+2];  //blue
      
      pCommand = pRGB.indexOf(max(pRGB));

      if (pCommand == 0) {
        commands += 'r';
      } else if (pCommand == 1) {
        commands += 'b';
      } else if (pCommand == 2) {
        commands += 'g';
      }
      
    }
  
  
  //commands is not empty
  //display first 100 commands in the console
  for(var i = 0; i<100; i++){
    print("command " + i.toString() +": " + commands[i]);
  }
  
  //display number of commands
  print("number of commands: " + commands.length); 
  
  //maybe the commands did not show in your case, because the number of commands is so huge.
  //p5js needs a very long time to process them, and does not show anything in the loadingtime
  //printing to the console takes a lot of time and should better not be done in long for loops
}

function preload() {
  //add the name of your image
  //the image should be contained in "assets" folder under the project file
  img = loadImage("assets/cat_small.jpg");
}

function setup() {

  angleMode(DEGREES);
  createCanvas(windowWidth, windowHeight);
  image(img, 0, 0, windowWidth, windowHeight);
  
  commandSetup();


  turtle = {

    x: 300,
    y: 300,

    turnangle: 120,
    stepsize: 1,

    heading: -PI / 4,

    goto: function(x, y) {
      this.x = x;
      this.y = y;
    },

    forward: function(distance) {
      var px = this.x;
      var py = this.y;
      this.x = this.x + distance * cos(this.heading);
      this.y = this.y + distance * sin(this.heading);

      var strokeR = map(this.y, height/2, height, 255, 0);
      var strokeG = map(this.x, width/2, width, 255, 0);
      var strokeB = map(this.x, 0, width/2, 0, 255);
      strokeWeight(3);
      stroke(color(strokeR, strokeG, strokeB));

      line(px, py, this.x, this.y);

    },

    turn: function(angle) {
      this.heading = (this.heading + angle) / 2;
    },

    obey: function(commands) {
      for (var i = 0; i < commands.length; i++) {
        var cmd = commands[i];

        switch (cmd) {

          case 'r':
            this.turn(-PI / 2);
            this.forward(this.stepsize);

            break;

          case 'g':
            this.turn(-this.turnangle);
            this.forward(this.stepsize);
            break;

          case 'b':
            this.turn(+this.turnangle);
            this.forward(this.stepsize);
            break;

        }
      }
    },

    width: 100,
    height: 100

  };

  turtle.goto(width / 2, height / 2);
}

function draw() {
  
  if (step < commands.length) {
    turtle.obey(commands[step]);
    step = step + 1;
  } else {
    turtle.goto(width / 2, height / 2);
    turtle.heading = -PI / 4;
    step = 0;
  }



}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
}