//
//  videoClass.cpp
//  BBP
//
//  Created by Sarah Pacheco Alvim on 07/01/19.
//

#include "videoClass.hpp"

//--------------------------------------------------------------
void videoClass::setup(){
    
    totalMovies = 8;
    nowPlayer = 0;
    loadingMovieId = 0;
    
    playAndPreload();
    
}

//--------------------------------------------------------------
void videoClass::playAndPreload(){
    
    // PLAY the current movie
    
    // need to load the first movie : should only happen once
    if( !video[nowPlayer].isLoaded() ){
        video[nowPlayer].load(ofToString(loadingMovieId + 1) + "File.mov" );
    }
    
    video[nowPlayer].setLoopState(OF_LOOP_NONE);
    video[nowPlayer].play();
    
    cout << "playing: " << video[nowPlayer].getMoviePath() << endl;
    
    //--------------------
    
    // PRELOAD the next movie
    
    // get a unique random ID
    int preloadId = floor(ofRandom(totalMovies));
    while (preloadId == loadingMovieId ) {
        preloadId = floor(ofRandom(totalMovies));
    }
    
    // set the loading movie to the new ID
    loadingMovieId = preloadId;
    
    // load movie in the player that isn't 'nowPlayer'
    int nextPlayer = nowPlayer == 0 ? 1 : 0;
    video[nextPlayer].load(ofToString(loadingMovieId+1) + "File.mov" );
    
    cout << "loading: " << video[nextPlayer].getMoviePath() << "\n" << endl;
    
}

//---------------------------------------------------------------
void videoClass::update(){
    
    video[nowPlayer].update();
    
    // check for 'isMovieDone' ( *I think this is better to do within the 'update' method* )
    if( video[nowPlayer].getIsMovieDone() ){
        
        // stop currently playing video
        video[nowPlayer].stop();
        
        // swap video player ID
        nowPlayer = ( nowPlayer == 0 ) ? 1 : 0;
        
        // make the magic happen
        playAndPreload();
    }
}

//--------------------------------------------------------------
void videoClass::draw(){
    
    video[nowPlayer].draw(0,0, ofGetWidth(), ofGetHeight());
    
}
