//
//  textClass.cpp
//  BBP
//
//  Created by Sarah Pacheco Alvim on 07/01/19.
//

#include "textClass.hpp"

//--------------------------------------------------------------
void textClass::setup(){
    
    ofSetFrameRate(30);
    
    lastTime = ofGetElapsedTimef();
    frameRateForCapture = 30; // 30 fps
    lineCount = 0;
    
    totalTexts = 2;
    loadingTextId = 0;
    nowBuffer = 0;
    
    myFont.load("Arial.ttf", 20, true, true, true);
    shadowFont.load("Arial.ttf", 20, true, true, true);
    // myFont.load("Helvetica.dfont", 20);
    
    playAndPreload();
    
}

//--------------------------------------------------------------
void textClass::playAndPreload(){
    
    // this is our buffer to stroe the text data
    ofBuffer nowBuffer = ofBufferFromFile(ofToString(loadingTextId + 1) + ".txt");
    
    if(nowBuffer.size()) {
        
        for (ofBuffer::Line it = nowBuffer.getLines().begin(), end = nowBuffer.getLines().end(); it != end; ++it) {
            
            string line = *it;
            
            // copy the line to draw later
            // make sure its not a empty line
            if(line.empty() == false) {
                seussLines.push_back(line);
            }
            
            // print out the line
            cout << "playing: " << nowBuffer << endl;
        }
    }
    
    
    //--------------------
    // PRELOAD the next movie
    
    // get a unique random ID
    int preloadId = floor(ofRandom(totalTexts));
    while (preloadId == loadingTextId ) {
        preloadId = floor(ofRandom(totalTexts));
    }
    
    // set the loading text to the new ID
    loadingTextId = preloadId;
    
    ofBuffer nextBuffer = ofBufferFromFile(ofToString(loadingTextId + 1) + ".txt");
    
    cout << "loading: " << nextBuffer << "\n" << endl;
}

//--------------------------------------------------------------
void textClass::update(){
    
    ofBuffer nowBuffer;
    
    // check for 'isMovieDone' ( *I think this is better to do within the 'update' method* )
    if(nowBuffer.size()) {
        
        for (ofBuffer::Line it = nowBuffer.getLines().begin(), end = nowBuffer.getLines().end(); it != end; ++it) {
            
            string line = *it;
            
            if(line.empty() == true) {
                // stop currently playing video
                nowBuffer.end();
                
                // swap video player ID
                ofBuffer nowBuffer = ofBufferFromFile(ofToString(loadingTextId + 1) + ".txt");
                
                // make the magic happen
                playAndPreload();
            }
            
        }
        
    }
    
}

//--------------------------------------------------------------
void textClass::draw(){
    
    // the total width on the line, dá para multiplicar se as linhas forem muito pequenas e eu quero q o tempo delas na dela n seja regularmente com strWidth60 como estabeleci alí em baixo
    int strWidth = (seussLines[lineCount].length());
    
    float x = (ofGetWidth()-(strWidth*8+5))/2;
    float y = ofGetHeight()/2;
    
    // we are slowy grabbing part of the line
    string typedLine = seussLines[lineCount];
    
    
    // draw the line
    ofPushStyle();
    // ofSetColor(255, 204, 0);
    ofSetColor(0,0,0,127);
    ofDrawRectangle(x-(ofGetWidth()/16)-30, y+230, (strWidth*12)+80, 45);
    ofSetColor(255);
    myFont.drawString(typedLine, x-(ofGetWidth()/16), y+260);
    ofPopStyle();

     cout << "strwidth: " << strWidth << endl;
    if (strWidth < 40 ){
        strWidth = 40;
    }
    
    // timePerFrame: pega o tamanho da linha e divideo pelo framerate(30). Ou seja, se a linha for muito grande, ela fica mais tempo na tela, se for curta, fica menos. O mínimo de tempo que uma linha fica na tela é 60/30=2, pq estabeleci no "if" anterior que se a linha for menor que 60, deve ser considerada 60, caso contrário a legenda é muito rápida.
    float timePerFrame = (strWidth*1.5) / frameRateForCapture;
    float currentTime = ofGetElapsedTimef();
    
    
    //Se o current time, que corresponde ao ElapsedTime mas sem ser em milisegundos, for maior que o lastTime, que é o o ElapsedTime, tb sem ser em milisegundos mas declarado lá no topo em setup, for maior que 2 (ou o resultado da divisão do timePerFrame)...
    if (currentTime - lastTime > timePerFrame){
        
        lineCount ++;
        lineCount %= seussLines.size();
        lastTime = currentTime;
    }
    
}
