//
//  audioClass.cpp
//  BBP
//
//  Created by Sarah Pacheco Alvim on 07/01/19.
//

#include "audioClass.hpp"

//--------------------------------------------------------------
void audioClass::setup(){
    
    totalAudio = 8;
    nowPlayer = 0;
    loadingSong = 0;
    
    playAndPreload();
}

//--------------------------------------------------------------
void audioClass::playAndPreload(){
    
    if( !audio[nowPlayer].isLoaded() ){
        audio[nowPlayer].load(ofToString(loadingSong + 1) + "File.aiff" );
    }
    
    audio[nowPlayer].play();
    
    cout << "playing: " << loadingSong << endl;
    
    
    int preloadID = floor(ofRandom(totalAudio));
    while (preloadID == loadingSong) {
        preloadID = floor(ofRandom(totalAudio));
    }
    
    loadingSong = preloadID;
    
    int nextPlayer = nowPlayer == 0 ? 1 : 0;
    audio[nextPlayer].load(ofToString(loadingSong + 1) + "File.aiff");
    
    cout << "loading: " << preloadID << "\n" << endl;
    
}

//---------------------------------------------------------------
void audioClass::update(){
    
    // check for 'isAudioDone'
    if( audio[nowPlayer].getPosition() == 0 ){
        
        // stop currently playing audio
        audio[nowPlayer].stop();
        
        // swap sound player ID
        nowPlayer = ( nowPlayer == 0 ) ? 1 : 0;
        
        // make the magic happen
        playAndPreload();
    }
}
