class Line {
  int sx, sy, ex, ey;
  ArrayList points;

  Line(int sx_, int sy_, int ex_, int ey_) {
    sx = sx_;
    sy = sy_;
    ex = ex_;
    ey = ey_;
    points = new ArrayList();
    for (int i = 0; i < height; i = i + 5) {
      points.add (new Point(sx, i));
    }
  }

  void update() {
    for (int i = points.size()-1; i >= 0; i--) {
      Point point = (Point) points.get(i);
      point.update();
    }
  }

  void draw(color c) {
    smooth();
    noFill();
    stroke(c);
    beginShape();
    curveVertex(sx, sy);
    for (int i = points.size()-1; i >= 0; i--) {
      Point point = (Point) points.get(i);
      point.drawVertex();
    }
    curveVertex(ex, ey);
    endShape();
  }
}
