/**
 * linebender
 * ----------
 *
 * press UP-key to reset
 * press left mouse button to save current frame as pdf
 */

import processing.pdf.*;
boolean record;

ArrayList lines;
ArrayList agents;

void setup() {
  size(400, 400);
  colorMode(HSB, 360, 100, 100);
  reset();
}

void reset() {
  lines = new ArrayList();
  agents = new ArrayList();

  for (int i = 0; i < width/4; i = i + 2) {
    lines.add (new Line(i, 0, i, height));
  }
  
  int r = int(random(1,3));
  
  for(int i = 1; i <= r; i++) {
    int x = (int) random(0, width/4);
    int y = (int) random(0, height/4);
    agents.add (new Agent(x, y));
  }
}

void draw() {
  if (record) {
    beginRecord(PDF, "frame-####.pdf"); 
    colorMode(HSB, 360, 100, 100);
  }
  
  scale(4);
  
  background(0, 0, 100);

  for (int i = agents.size()-1; i >= 0; i--) {
    Agent agent = (Agent) agents.get(i);
    agent.move();
  }
  
  color c = color(138, 30, 59, 100);
  for (int i = lines.size()-1; i >= 0; i--) {
    Line line = (Line) lines.get(i);
    line.update();
    line.draw(c);
  }
  
  Line line = (Line) lines.get(33);
  line.draw(color(5, 100, 69, 255));

  if (!record) {
    for (int i = agents.size()-1; i >= 0; i--) {
      Agent agent = (Agent) agents.get(i);
      agent.draw();
    }
  }
  
  if (record) {
    endRecord();
    record = false;
  }

}

void keyPressed() {
  if (key == CODED) {
    if (keyCode == UP) {
      reset();
    }
  }
}

void mousePressed() {
  record = true;
}
