/*
 
 Description: 
 - strong value contrast between your hand and a white background.
 - Press mouse can pause the video
 -“s” stands for save the picture.
 -“a” stands for add the number of the balls
 -“m” stands for minus the number of the balls
 
 */

import JMyron.*;

JMyron m;//a camera object

float objx = 320;
float objy = 240;
float objdestx = 320;
float objdesty = 240;

int numBalls = 25600;
int maxBalls = numBalls;
int fps;
boolean clearBG, doSmooth;
int shapeType;
float maxVelocity = 16, minAccel = 0.8, maxAccel = 1.8;

Seeker[] ball = new Seeker[numBalls];

void setup() {
  size(640, 480);
  m = new JMyron();//make a new instance of the object
  m.start(width, height);//start a capture at 640x480
  m.trackColor(255, 255, 255, 256*3-100);//track white
  m.update();
  m.adaptivity(10);
  m.adapt();// immediately take a snapshot of the background for differencing
  println("Lively dots ");
  rectMode(CENTER);
  noStroke();

  colorMode(HSB, 255);
  smooth();
  shapeType = 1;

  for (int i=0; i<numBalls; i++) {
    ball[i] = new Seeker(new PVector(random(width), random(height)));
  }

  // numBalls adjusted to a sane default for web distribution
  numBalls = 400;
}


void draw() {
  m.update();//update the camera view
  drawCamera();

  int[][] centers = m.globCenters();//get the center points
  //draw all the dots while calculating the average.
  float avX=0;
  float avY=0;
  for (int i=0;i<centers.length;i++) {
    avX += centers[i][0];
    avY += centers[i][1];
  }
  if (centers.length-1>0) {
    avX/=centers.length-1;
    avY/=centers.length-1;
  }

  //update the location of the thing on the screen.
  if (!(avX==0&&avY==0)&&centers.length>0) {
    objdestx = avX;
    objdesty = avY;
  }
  objx += (objdestx-objx)/10.0f;
  objy += (objdesty-objy)/10.0f;
  rectMode(CENTER);
  for (int i=0; i<numBalls; i++) {
    ball[i].seek(new PVector(objx, objy));
    ball[i].render();
  }
}
void drawCamera() {
  int[] img = m.differenceImage(); //get the normal image of the camera
  loadPixels();
  for (int i=0;i<width*height;i++) { //loop through all the pixels
    pixels[i] = img[i]; //draw each pixel to the screen
  }
  updatePixels();
}

public void stop() {
  m.stop();//stop the object
  super.stop();
}


boolean bStop;
void mousePressed()
{
  bStop = !bStop;
  if (bStop)
    noLoop();
  else
    loop();
}
void keyPressed() {
  if (key == 's') { 
    saveFrame("Screenshot-####.jpg");
  }
  if ((key == 'm' || key == 'M')) {
    numBalls-=50;
    numBalls = max(0, numBalls);
  }
  if (key == 'a' || key == 'A') {
    numBalls+=50;
    numBalls = min(maxBalls, numBalls);
  }
}

