import ddf.minim.*; // minim-Audio-Toolkit
Minim minim; // Instanz der minim Bibliothek
// Instanzen der Audiofiles
AudioSample shot;
AudioSample glass;

//globale Variablen

PFont font;

PImage backgroundimage;

int Xres=600; //screenWidth
int Yres=600; //screenHeight

ArrayList snowflakes_array;

//Schneeflockenklasse

class Asnowflake
{  
  float ypos;
  float speed=1;
  float count=20;
  float xpos;
  int flakesize;
  float varBlue = random(50, 100);
  float Ysize; 
  float Xsize; 
  
  PImage schneeflocke = loadImage("schneeflocke.png");
  
  Asnowflake (float y,float x, float sp, int si) 
  {  
    speed = sp;
    ypos=y;
    xpos=x;
    flakesize = si;
    
    schneeflocke.resize(flakesize,flakesize);

    Ysize = schneeflocke.height;
    Xsize = schneeflocke.width;
  }
  
  boolean collission()
  {
    if((mouseX > xpos) && (mouseY > ypos) && (mouseY < ypos+Ysize) && (mouseX < xpos+Xsize)) 
    { 
    return true;
    } else return false;
  }
  
  void update()
  { 
    ypos += speed; 
    if (ypos > Yres+Ysize*2)
    { 
      ypos = 0-Ysize;
      xpos = random(0,Xres);
    }
    
    // sin(x)*y  x=periodenlänge, y=amplitude
    //xpos=xpos+sin(ypos/20)/(Ysize/20);
    xpos=xpos+sin(ypos/Ysize)*Ysize/20;  
    //xpos=xpos+sin(ypos*(Ysize/4)/500)*(Ysize/40);
    
    image(schneeflocke,xpos,ypos);
  }
}

void mousePressed() //mouseClicked
{
  shot.trigger(); 
}

void setup() 
{
  minim = new Minim (this);
  // Audiodatei aus dem data-Ordner laden
  shot = minim.loadSample ("40161__nonoo__flobert1-20070728.aiff",256);
  glass = minim.loadSample ("977__rhumphries__rbh-glass-break-01.aiff",256);
  backgroundimage = loadImage("winter.jpg");
  //Ysize = backgroundimage.height;
  //Xsize = backgroundimage.width;
  backgroundimage.resize(Xres,Yres);
  
  //erzeugen eines fontdatei und laden selbiger
  font = createFont("AGaramondPro-Bold-48",20); //name, size, smooth, charset
  textFont(font);
  
  frameRate(50);
    
  size(Xres, Yres); //fensterauflösung festlegen
  
  //erzeugen der schneeflocken
  
  snowflakes_array = new ArrayList();
  
  int anz=30;
  
  for (int i=1;i<=anz;i++)
  {
    snowflakes_array.add(new Asnowflake(random(0,Yres),random(0,Xres),random(4,4.5),50));
  }
  
  for (int i=1;i<=anz*2;i++)
  {
    snowflakes_array.add(new Asnowflake(random(0,Yres),random(0,Xres),random(2.5,3),40));
  }
  
  for (int i=1;i<=anz*4;i++)
  {
    snowflakes_array.add(new Asnowflake(random(0,Yres),random(0,Xres),random(0.1,0.5),20));
  }
}

void drawcursor()
{
  stroke(0); strokeWeight(3); noFill();
  ellipse(mouseX,mouseY,30,30);
  ellipse(mouseX,mouseY,15,15);
  line(mouseX, mouseY-20,mouseX,mouseY+20);
  line(mouseX-20, mouseY,mouseX+20,mouseY);
  smooth();
}

void draw()
{ 
  noCursor();
  
  //background(100, 100, 100);
  image(backgroundimage,0,0);
  
  //durchlaufen der arraylist, die die flocken enthält und updaten der variablen
  
  for (int i=0;i<=snowflakes_array.size()-1;i++)
  {
    Asnowflake Asnowflake = (Asnowflake) snowflakes_array.get(i);
    
    if(mousePressed)
    {
      if(Asnowflake.collission())
      {
      snowflakes_array.remove(i);
      glass.trigger (); 
      mousePressed = false;
      }
    }
    Asnowflake.update();
  }

  fill(255, 255, 255);
  text("Snowflakes:"+snowflakes_array.size(), 10, 10, 500, 100); //text,x,y,width textbox,height textbox
  text("Frames:"+ceil(frameRate), 10, 40, 500, 100); //text,x,y,width textbox,height textbox
  
  drawcursor();
} 

