//virtuelle zeichenfläche erstellen
PGraphics pg;

int factor = 2;

int VirtualScreenXres;
int VirtualScreenYres;
int ScreenXres;
int ScreenYres;

int frames = 0;

int timer = 0;

PFont font;

ArrayList shots_array;
ArrayList enemy_array;
ArrayList star_array;

int _HeroX;
int _HeroY;

boolean userClick;

//images
PImage spaceship;
PImage shotimage;
PImage pixel;

//backgroundscrolling
int _xscrollingspeed = 1;
int _xscrolling;

PImage[] asteroidsprites;

class Stars
{
  int xpos;
  int ypos;
  int speed;
  
  Stars(int x, int y,int sp)
  {
    xpos=x;
    ypos=y;
    speed=sp;
  }
  
  void Update()
  {
    ypos+=speed;
    if(ypos>VirtualScreenYres)
    {
      ypos=0;
    }
    //ellipse(xpos,ypos,speed,speed);
    pg.image(pixel,xpos,ypos);
  }
}

class ASimpleEnemy
{
  int xpos;
  int ypos;
  int life;
  int speed = 4;
  int anipos = 0;

  ASimpleEnemy(int x, int y,int sp)
  {
    xpos=x;
    ypos=y;
    speed=sp;
    anipos=int(random(0,18));
  }
  
  boolean outofscreen()
  {
    if(ypos > VirtualScreenYres)    {
    return true;
    } else return false;
  }
  
  void Update()
  {
    ypos+=speed;
    anipos = frames % 18;
    pg.image(asteroidsprites[anipos],xpos,ypos);
  }
}

class ASimpleShot
{
  float ypos;
  float xpos;
  float speed=1;
  int offset=0;

  int collission = 0;
  
  //enemy
  float Ysize; 
  float Xsize; 
  
  ASimpleShot (float y,float x, float s) 
  {  
    speed = s;
    ypos=y-20;
    xpos=x+shotimage.width/2*factor;
  }
  
  boolean collission()
  {
    if((mouseX > xpos) && (mouseY > ypos) && (mouseY < ypos+Ysize) && (mouseX < xpos+Xsize))     { 
    return true;
    } else return false;
  }
  
  boolean outofscreen()
  {
    if(ypos < 0)    {
    return true;
    } else return false;
  }
  
  void update()
  { 
    ypos -= speed; 
    
    //collission();
    
    //xpos=random(xpos-Ysize/100,xpos+Ysize/100);
    
    //xpos=xpos+sin(ypos/20)/(Ysize/20); // sin(x)*y  x=periodenlänge, y=amplitude
    //xpos=xpos+sin(ypos*(Ysize/4)/500)*(Ysize/40);
    
    pg.image(shotimage,xpos,ypos);

  }
}

void mousePressed()
{
  userClick = true;
}

void mouseReleased()
{
  userClick = false;
}

void mouseMoved()
{

}

int setposition(int pos)
{
  return pos*2;
}

void setup() 
{
  font = createFont("AGaramondPro-Bold-12",12); //name, size, smooth, charset
  //font = loadFont("AGaramondPro-Bold-12.vlw"); //name, size, smooth, charset

  textFont(font);
  
  frameRate(25);
  timer = millis();
/*
  VirtualScreenXres = screenWidth/2;
  VirtualScreenYres = screenHeight/2;
  size(screenWidth, screenHeight, JAVA2D);
*/
  ScreenXres = 400;
  ScreenYres = 600;
  VirtualScreenXres = ScreenXres/2;
  VirtualScreenYres = ScreenYres/2;
  size(ScreenXres, ScreenYres, JAVA2D);

  pg = createGraphics(VirtualScreenXres, VirtualScreenYres, JAVA2D);
  
  noCursor();//entfernen für android
  
  shots_array = new ArrayList();
  enemy_array = new ArrayList();
  star_array = new ArrayList();
  
  asteroidsprites = new PImage[19];
  for(int i=0;i<18;i++)
  {
    String filename = "aster" + nf(i+1, 3) + ".png";
    asteroidsprites[i] = loadImage(filename);
  }
  
  spaceship = loadImage("spaceship.png");
  shotimage = loadImage("shot2.png");
  pixel = loadImage("pixel.png");
 
  for(int i=0;i<100;i++)
  {
    star_array.add(new Stars(int(random(VirtualScreenXres)),int(random(VirtualScreenYres)),int(random(1,8))));
  }
}

void draw()
{
  frames++;
    
  _HeroX=mouseX/2-(spaceship.width/2);
  _HeroY=mouseY/2-(spaceship.height-10);
  
  if(userClick && frames%5==0) 
  {
    shots_array.add(new ASimpleShot(_HeroY,_HeroX+20,10));
    shots_array.add(new ASimpleShot(_HeroY,_HeroX-20,10));
  }
  
  pg.beginDraw();
  
  pg.background(6, 6, 40);
  _xscrolling += _xscrollingspeed;
  //noisegen(height/3,0,150); 
  
  for(int i=0;i<star_array.size();i++)
  {
     Stars Stars = (Stars) star_array.get(i);
     Stars.Update();
  }
  
  //if((millis()%8==0))
  if((frames%8==0))
  {
    enemy_array.add(new ASimpleEnemy(int(random(0,VirtualScreenXres)),-80,4));
  }

  for (int i=0;i<=enemy_array.size()-1;i++)
  {
     ASimpleEnemy ASimpleEnemy = (ASimpleEnemy) enemy_array.get(i);
     if(ASimpleEnemy.outofscreen())
     {
       enemy_array.remove(i);
     }
     ASimpleEnemy.Update();
  }
  
  pg.image(spaceship,_HeroX,_HeroY);
  
  for (int i=0;i<=shots_array.size()-1;i++)
  {
    ASimpleShot ASimpleShot = (ASimpleShot) shots_array.get(i);
    
    if(ASimpleShot.outofscreen())
    {
      shots_array.remove(i);
    }
    
    //kollissionsabfrage
    for (int ii=0;ii<=enemy_array.size()-1;ii++)
    {
       ASimpleEnemy ASimpleEnemy = (ASimpleEnemy) enemy_array.get(ii);
       if(
       (ASimpleShot.xpos > ASimpleEnemy.xpos-asteroidsprites[0].width) && 
       (ASimpleShot.ypos > ASimpleEnemy.ypos-asteroidsprites[0].height) && 
       (ASimpleShot.ypos < ASimpleEnemy.ypos+asteroidsprites[0].height) && 
       (ASimpleShot.xpos < ASimpleEnemy.xpos+asteroidsprites[0].width)) 
       enemy_array.remove(ii);
    }    
    
    if(ASimpleShot.collission())
    {
      shots_array.remove(i);
    }

    ASimpleShot.update();
  }
  
  // debugging variables

  fill(255, 255, 255);
  //text,x,y,width textbox,height textbox
  pg.text(
  "ShotsAlive:"+shots_array.size()+"\n"
  +"Stars:"+star_array.size()+"\n"  
  +"fps:"+ceil(frameRate)+"\n"
  +"EnemyAlive:"+enemy_array.size()
  , 5, 5, VirtualScreenXres, VirtualScreenYres); 

  //println(frameRate);
  
  pg.endDraw();
  image(pg, 0, 0, ScreenXres,ScreenYres); 
} 

