/* Class, which controlls the points for one shape
 
 points    an array of points
 */
class PointArray {
  ArrayList points;

  /*  Constructor, which creates the points array
   */
  PointArray() {
    points= new ArrayList();
  }

  /*  Method return the x value of the specified index
   
   index  index of the points, which should returns its x position
   */
  float getXFrom(int index) {
    Point retValue= (Point)points.get(index);
    return retValue.x;
  }

  /*  Method return the y value of the specified index
   
   index  index of the points, which should returns its y position
   */
  float getYFrom(int index) {
    Point retValue=(Point)points.get(index);
    return retValue.y;
  }

  /*  Method adds a new point at the end of the points array
   
   x  x value of the new point
   y  y value of the new point
   */
  void addPoint(float x, float y) {
    points.add(new Point(x, y));
  }

  /*  Method removes a new pointwith the specified index
   
   index  index of the point, which should removed
   */
  void removePointAt(int index) {
    points.remove(index);
  }

  /*  Method return the length of the points array (or the number of stored points)
   */
  int getLength() {
    return points.size();
  }
}

