//randomMode for the position of the shapes
boolean randomIsOK=true;
//randomValue, will be transformed to -randomValue to randomValue
int randomValue=10;
//should the background set in every draw cycle, if not a rectangle will be drawn with the bgColor
boolean resetBackground=true;
//the color for the rectangle in the background, only if resetBackground is false, otherwise the backgrund itself will get this color
color bgColor=color(50, 50);
//size of the window
float frameWidth=800;
float frameHeight=600;
//The Font, to be used
PFont theFont;
//Possible Shapes, declared in another tab
ShapeNumber allPossibleShapes;
//The current shape number (from class ShapeNumber)
int currentShape;
//The next shape number (from class ShapeNumber)
int nextShape;
//if the shape is in the process of a transition between two shapes
boolean shapeInTransition;
//Width of the rectangle and inner diameter of the star
final float SIZE_X=100;
//Outer diameter of the star
final float SIZE_Y=100;
//current width of the rectangle or inner diameter of the star
float sizeX=100;
//Current outer diameter of the star
float sizeY=100;
//Number of shapes in x diretion <->
int shapeX=6;
//Number of shapes in y diretion
int shapeY=6;
//Number of steps for the roundness of a circle, should not be changed
int steps=30;
// left x position for the first shape
int orgX=0;
// top y position for the first shape
int orgY=0;
float stepToCircle=4;
//Array of points, which forms the shape
PointArray shapePoints;
// Maximum of shapes in x direction
final int maxShapeNumberX=10;
// Maximum of shapes in y direction
final int maxShapeNumberY=10;
//ArrayList of colours
ArrayList colorArray;

/*Setup method
 
 Will init all the basic members
 */
void setup() {
  allPossibleShapes= new ShapeNumber();
  size(800, 600);

  //size((int)frameWidth, (int)frameHeight);
  currentShape= allPossibleShapes.SQUARE;
  nextShape= allPossibleShapes.SQUARE;
  shapeInTransition=false;
  theFont=loadFont("TheFont.vlw");
  //"draw" a rectangle at the begining (with four points)
  shapePoints= new PointArray();
  shapePoints.addPoint(sizeX/10, sizeX/10);
  shapePoints.addPoint(sizeX-sizeX/10, sizeX/10);
  shapePoints.addPoint(sizeX-sizeX/10, sizeX-sizeX/10);
  shapePoints.addPoint(sizeX/10, sizeX-sizeX/10);
  smooth();
  frameRate(8);
  noStroke();
  //create the colorArray
  colorArray= new ArrayList();
  for (int i=0;i<maxShapeNumberY;i++) {
    ArrayList cArray= new ArrayList();
    for (int j=0;j<maxShapeNumberX;j++) {
      cArray.add(new ColorTransition(round(random(255)), round(random(255)), round(random(255))));
    }
    colorArray.add(cArray);
  }
}
/*  The draw method, invoked every frame
 */
void draw() {
  //If resetBackground, the background gets its color, otherwise a rectangle (with alpha fill) will be drawn
  if (resetBackground) {
    background(red(bgColor), green(bgColor), blue(bgColor));
  }
  else {
    fill(bgColor);
    rect(0, 0, frameWidth, frameHeight);
  }
  pushMatrix();
  //if a transition between two shapes is finished, calculate the next shape
  if (!shapeInTransition) {
    nextShape=round(random(allPossibleShapes.getMaximum()));
    if (currentShape==nextShape) {
      nextShape++;
      if (nextShape>allPossibleShapes.getMaximum()) {
        nextShape=0;
      }
    }
    shapeInTransition=true;
  }
  //Calculate the points, which are needed for the specific shape
  if (shapeInTransition) {
    if (nextShape == allPossibleShapes.SQUARE) {
      transformToASquare();
    }
    else if (nextShape == allPossibleShapes.CIRCLE) {
      transformToACircle();
    }
    else if (nextShape == allPossibleShapes.STAR) {
      transformToAStar();
    }
  }

  //draw the shape on screen
  for (int k=0;k<shapeY;k++) {
    ArrayList cA=(ArrayList)colorArray.get(k);
    for (int j=0;j<shapeX;j++) {
      ColorTransition c=(ColorTransition)cA.get(j);
      fill(c.getCurrentColor());
      pushMatrix();
      //if randomIsOk, the position will be changed randomly to ots origin
      if (randomIsOK) {
        translate((mouseX-orgX+sizeX)/shapeX*j+orgX+random(-randomValue, randomValue), (mouseY-orgY+sizeX)/shapeY*k+orgY+random(-randomValue, randomValue));
      }
      else {
        translate((mouseX-orgX+sizeX)/shapeX*j+orgX, (mouseY-orgY+sizeX)/shapeY*k+orgY);
      }
      beginShape();
      for (int i=0;i<shapePoints.getLength();i++) {
        vertex(shapePoints.getXFrom(i), shapePoints.getYFrom(i));
      }
      endShape(CLOSE);

      popMatrix();
    }
  } 
  popMatrix();
  //Draw the controll options
  drawControlOptions();
}

/*  Methods tweens from the other shapes to the square
 
 Previous shapes are circle and star
 */
void transformToASquare() {
  //Tween from Circle to Square
  if (currentShape == allPossibleShapes.CIRCLE) {
    shapePoints= new PointArray();
    if (stepToCircle>=steps) {
      shapePoints.addPoint(sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX-sizeX/10);
      shapePoints.addPoint(sizeX/10, sizeX-sizeX/10);
    }
    else {
      for (int i=0; i<(steps+4)-stepToCircle;i++) {
        shapePoints.addPoint(sin(radians(360/((steps+4)-stepToCircle)*i + 45))*sizeX/2+sizeX/2, cos(radians(360/((steps+4)-stepToCircle)*i +45))*sizeX/2+sizeX/2);
      }
    }
    stepToCircle++;
    //steps+10, because square should be longer visible on screen
    if (stepToCircle==steps+10) {
      stepToCircle=4;
      currentShape= allPossibleShapes.SQUARE;
      shapeInTransition=false;
      sizeY=SIZE_Y;
    }
  }
  //Tween from Star to Square
  else if (currentShape == allPossibleShapes.STAR) {
    shapePoints= new PointArray();
    if (stepToCircle>=steps/2-4) {
      shapePoints.addPoint(sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX-sizeX/10);
      shapePoints.addPoint(sizeX/10, sizeX-sizeX/10);
    }
    else {
      sizeY+=4;
      for (int i=0; i<steps/2-stepToCircle;i++) {
        shapePoints.addPoint(sin(radians(45+ 360/(steps/2-stepToCircle)*i) )*sizeX/2+sizeX/2, cos(radians(45+360/(steps/2-stepToCircle)*i))*sizeX/2+sizeX/2);
        shapePoints.addPoint(sin(radians(45+ 360/(steps/2-stepToCircle)*(i+0.5)))*sizeY/2+sizeX/2, cos(radians(45+360/(steps/2-stepToCircle)*(i+0.5)))*sizeY/2+sizeX/2);
      }
    }
    stepToCircle++;
    //steps/2+10, because square should be longer visible on screen
    if (stepToCircle==steps/2+10) {
      stepToCircle=4;
      currentShape= allPossibleShapes.SQUARE;
      shapeInTransition=false;
      sizeY=SIZE_Y;
    }
  }
}

/*  Methods tweens from  other shapes to a circe
 
 Previous shapes are square and star
 */
void transformToACircle() {
  //Tween from Square to circle
  if (currentShape == allPossibleShapes.SQUARE) {
    shapePoints= new PointArray();
    if (stepToCircle==4) {
      shapePoints.addPoint(sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX-sizeX/10);
      shapePoints.addPoint(sizeX/10, sizeX-sizeX/10);
    }
    else {
      for (int i=0; i<stepToCircle;i++) {
        shapePoints.addPoint(sin(radians(360/stepToCircle*i+ 45))*sizeX/2+sizeX/2, cos(radians(360/stepToCircle*i+45))*sizeX/2+sizeX/2);
      }
    }
    stepToCircle++;
    if (stepToCircle==steps) {
      stepToCircle=4;
      currentShape= allPossibleShapes.CIRCLE;
      shapeInTransition=false;
      sizeY=SIZE_Y;
    }
  }
  //Tween from Star to circle
  else if (currentShape == allPossibleShapes.STAR) {
    shapePoints= new PointArray();
    sizeY+=4;
    for (int i=0; i<steps/2;i++) {
      shapePoints.addPoint(sin(radians(360/steps*2*i))*sizeX/2+sizeX/2, cos(radians(360/steps*2*i))*sizeX/2+sizeX/2);
      shapePoints.addPoint(sin(radians(360/steps*2*(i+0.5)))*sizeY/2+sizeX/2, cos(radians(360/steps*2*(i+0.5)))*sizeY/2+sizeX/2);
    }
    stepToCircle++;
    if (stepToCircle==steps/2) {
      stepToCircle=4;
      currentShape= allPossibleShapes.CIRCLE;
      shapeInTransition=false;
      sizeY=SIZE_Y;
    }
  }
}

/*  Methods tweens from  other shapes to a star
 
 Previous shapes are square and circle
 */
void transformToAStar() {
  //Tween from Square to star
  if (currentShape == allPossibleShapes.SQUARE) {
    shapePoints= new PointArray();
    if (stepToCircle==4) {
      shapePoints.addPoint(sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX/10);
      shapePoints.addPoint(sizeX-sizeX/10, sizeX-sizeX/10);
      shapePoints.addPoint(sizeX/10, sizeX-sizeX/10);
    }
    else {
      sizeY-=4;
      for (int i=0; i<stepToCircle;i++) {
        shapePoints.addPoint(sin(radians(360/stepToCircle*i))*sizeX/2+sizeX/2, cos(radians(360/stepToCircle*i))*sizeX/2+sizeX/2);
        shapePoints.addPoint(sin(radians(360/stepToCircle*(i+0.5)))*sizeY/2+sizeX/2, cos(radians(360/stepToCircle*(i+0.5)))*sizeY/2+sizeX/2);
      }
    }
    stepToCircle++;
    if (stepToCircle==steps/2) {
      stepToCircle=4;
      currentShape= allPossibleShapes.STAR;
      shapeInTransition=false;
    }
  }
  //Tween from circle to star
  else if (currentShape == allPossibleShapes.CIRCLE) {
    stepToCircle++;
    shapePoints= new PointArray();
    sizeY-=4;
    for (int i=0; i<stepToCircle;i++) {
      shapePoints.addPoint(sin(radians(360/stepToCircle*i))*sizeX/2+sizeX/2, cos(radians(360/stepToCircle*i))*sizeX/2+sizeX/2);
      shapePoints.addPoint(sin(radians(360/stepToCircle*(i+0.5)))*sizeY/2+sizeX/2, cos(radians(360/stepToCircle*(i+0.5)))*sizeY/2+sizeX/2);
    }
    if (stepToCircle==steps/2) {
      stepToCircle=4;
      currentShape= allPossibleShapes.STAR;
      shapeInTransition=false;
    }
  }
}

/*  Draws the control options
 
 a/s          add/remove shapes in x direction
 d/f          add/remove shapes in y direction
 UP/DOWN      Move y position from shapes
 LEFT/RIGHT   Move x position from shapes
 */
void drawControlOptions() {
  fill (245);
  noStroke();
  rect(0, frameHeight-40, frameWidth, 40);
  fill (45);
  textFont(theFont, 13);
  textAlign(LEFT, BOTTOM);
  text("A or S - Add a new or remove a shape in x orientation            UP or DOWN      Move x position from shapes", 10, frameHeight-40, frameWidth, 20);
  text("D or F - Add a new or remove shape in y orientation                LEFT or RIGHT  Move y position from shapes", 10, frameHeight-23, frameWidth, 20);
}

/*  Will generate new random colours for every shape
 */
void mouseClicked() {
  for (int i=0;i<maxShapeNumberY;i++) {
    ArrayList cArray= (ArrayList)colorArray.get(i);
    for (int j=0;j<maxShapeNumberX;j++) {
      ColorTransition c=(ColorTransition) cArray.get(j);
      c.gotoNewColor(round(random(255)), round(random(255)), round(random(255)));
    }
  }
}

/*  Controls the keyboard input by releasing the key
 
 a  -  Add a new shape in x orientation (1-10)
 s - Remove a new shape in x orientatio (1-10)
 d - Add a new shape in y orientation (1-10)     
 f - Remove a new shape in y orientatio (1-10)
 */
void keyReleased() {
  switch (key) {
  case 'a': 
  case 'A':
    if (shapeX<maxShapeNumberX) {
      shapeX++;
    }
    break;
  case 's': 
  case 'S':
    if (shapeX>1) {
      shapeX--;
    } 
    break;
  case 'd': 
  case 'D':
    if (shapeY<maxShapeNumberY) {
      shapeY++;
    }
    break;
  case 'f': 
  case 'F':
    if (shapeY>1) {
      shapeY--;
    }
    break;
  }
}

/*  Controls the keyboard input by pressing the key
 
 UP  - Move the orgY 20 px up
 DOWN  - Move the orgY 20 px down
 LEFT  - Move the orgX 20 px left
 RIGHT  - Move the orgX 20 px right
 ENTER  - Reset the orgX and orgY to 0
 */
void keyPressed() {
  if (keyCode==UP) {
    orgY-=20;
  }
  if (keyCode==DOWN) {
    orgY+=20;
  }
  if (keyCode==LEFT) {
    orgX-=20;
  }
  if (keyCode==RIGHT) {
    orgX+=20;
  }
  if (keyCode==ENTER) {
    orgX=0;
    orgY=0;
  }
}

