/*  Class, which holds the color information. If you set a new one, it will tween between the current and the new color
 
 oldR              the current old red value
 oldG              the current old green value
 oldB              the current old blue value
 newR              the new red value (at the end of the tween)
 newG              the new green value (at the end of the tween)
 newB              the new blue value (at the end of the tween)
 transitionValue   Value to tween from oldColor to new Color (255-9-9-9-9-9-9-9-9....) 
 */
class ColorTransition {
  int oldR;
  int oldG;
  int oldB;
  int newR;
  int newG;
  int newB;
  int transitionValue=9;

  /*  Constructor, which initialized the object with the first red, green and blue value of the color
   
   r    red value of the color
   g    green value of the color
   b    blue value of the color
   */
  ColorTransition(int r, int g, int b) {
    oldR=newR=r;
    oldG=newG=g;
    oldB=newB=b;
  }

  /*  Method, which sets the new color
   
   r    the new red value
   g    the new green value
   b    the new blue value
   */
  public void gotoNewColor(int r, int g, int b) {
    newR=r;
    newG=g;
    newB=b;
  }

  /*  Method return the current color
   
   It will create the current value, by adjusting the currentcolor corresponding to the new color
   current color = currentColor +/- transitionsValue till oldR==newR, the same for green and blue
   */
  public color getCurrentColor() {
    oldR=checkColor(oldR, newR);
    oldG=checkColor(oldG, newG);
    oldB=checkColor(oldB, newB);

    return color(oldR, oldG, oldB);
  }

  /*  Helper method, to create the current color value (red, green or blue)
   
   oldC    current Color (red, green or blue)
   newC    new Color (red, green or blue)
   */
  protected int checkColor(int oldC, int newC) {
    int between = abs(oldC-newC);
    //if both values equal return the old one
    if (oldC==newC) {
      return oldC;
    }
    //If the old one is smaller the new one, it adds to the current one  the transitionvalue
    if (oldC<newC) {
      if (between<transitionValue) {
        oldC+=between;
      }
      else {
        oldC+=transitionValue;
      }
      return oldC;
    }
    //Only, if the oldC is bigger than the new one, return the current color minus the transitionvalue
    if (between<transitionValue) {
      oldC-=between;
    }
    else {
      oldC-=transitionValue;
    }
    return oldC;
  }
}

