import controlP5.*;

int frame = 0;
	int minus = 95;				
	int updateFrame = 1; 		
	float timeToLastFrame = 0.0f;
	float now = millis();
	PImage back;
	PImage colors;
	PGraphics pg;
	int NumberOfBalls = 30;
	MetaballManager MetBall;
	boolean motion = true;
	boolean releaseBall = false;
	boolean masterMode = false;
	float releasedBalls;
	int leftDistance_ = 10;
	int upDistance_ = 10;
	int downDistance_ = 40;
	int rightDistance_ = 120;
	int density = 1;
	ControlP5 controlP5;
	Button rButton;
	int finalRGB[] = {200,50,75};
	int oldRGB[] = {finalRGB[0],finalRGB[1],finalRGB[2]};
	
	
	
	public void setup(){
		
	  size(550,300);
	  frameRate(60);
	  smooth();
	  
	  back = loadImage("back.jpg");
	  colors = loadImage("farbkreis.jpg");
	  
	  pg = createGraphics((width-rightDistance_-leftDistance_)/2, (height-upDistance_-downDistance_)/2, P2D);
	  
	  MetBall = new MetaballManager(pg.width, pg.height, NumberOfBalls);
	  
	  pg.background(255);
	  
	  controlP5 = new ControlP5(this);
	  
	  int x = width-rightDistance_+15;
	  int y = 10;
	  
	  controlP5.addButton("Turn Blur off",0,x,y,100,19).setId(0);
	  controlP5.addButton("- Blur",1,x,y+20,100,19).setId(1);
	  controlP5.addButton("+ Blur",2,x,y+40,100,19).setId(2);
	  controlP5.addButton("Turn Mouse on",3,x,y+60,100,19).setId(3);
	  controlP5.addButton("Release all! (R)",4,x,y+80,100,19).setId(4);	 
	  
	}

	public void draw(){
		ControllerInterface[] controllers = controlP5.getControllerList();
		timeToLastFrame = millis()-now;
		now = millis();
		background(0);
		boolean releasing = releaseBall && (now-releasedBalls)/3000>1;
		if(releasing){
			MetBall.releaseBalls(releaseBall);	
			releaseBall = false;
			for(int i = 0; i<controllers.length; ++i){				
				if(controllers[i].id()==4){
					controllers[i].setLabel("Release all! (R)");
				}
			}
		}else{
			
		}
		
		if(releaseBall){
			for(int i = 0; i<controllers.length; ++i){				
				if(controllers[i].id()==4){
					controllers[i].setLabel("" + (3-(int)(now-releasedBalls)/1000));
				}
			}
		}
		
		if(masterMode){
			MetBall.balls[MetBall.balls.length-1].master = true;
			MetBall.balls[MetBall.balls.length-1].free = true;
			if(mouseX<width-90 && mouseX>10 && mouseY<height-30 && mouseY>10){
				MetBall.balls[MetBall.balls.length-1].PosX_ = 2.0f*(mouseX-10)/(width-rightDistance_) - 1.0f;
				MetBall.balls[MetBall.balls.length-1].PosY_ = 2.0f*(mouseY-10)/(height-downDistance_) - 1.0f;
			}
		}else{
			MetBall.balls[MetBall.balls.length-1].master = false;
		}
		MetBall.update(0.5f*timeToLastFrame);
		
		//////////////////////////////  LOAD PIXELS FROM THE SKETCH 
		pg.beginDraw();
		pg.loadPixels();			
		
		//////////////////////////////  CALC METABALLS
		for(int i = 0; i<pg.width; ++i){
			for(int j = 0; j<pg.height; ++j){
				
				//////////////////////////////  CALC THEIR COLORS
				float cols[] = new float[2];
				float rgb[] = new float[3];	
				float rgb2[] = new float[3];	
				for(int k = 0; k<NumberOfBalls; ++k){
	    			float r = MetBall.balls[k].radAnteil[i]+MetBall.balls[k].radAnteil[pg.width+j];
	    			float colR = 1.0f;
	    			for(int d = 0; d<density; ++d){
	    				colR /= r;	    				
	    			}
	    			float col = abs(colR);	    			
	    			////////////////////////////// ADD COLOR
	    			for(int c = 0; c<3; ++c){
	    				rgb[c] +=  (MetBall.balls[k].rgb[c]*col);
	    				rgb2[c] += col;
	    			}
	    		}  
	      	     
				//////////////////////////////  DRAW WITH MOTION BLUR - FALSE/TRUE
				if(motion){
	    			if(frame%updateFrame == 0 ){
	    				pg.pixels[j*pg.width+i] = color(max(red(pg.pixels[j*pg.width+i])   - minus, 0),
	    												max(green(pg.pixels[j*pg.width+i]) - minus, 0),
	    												max(blue(pg.pixels[j*pg.width+i])  - minus, 0));
	    			}
	    			pg.pixels[j*pg.width+i] = color(min(red(pg.pixels[j*pg.width+i])   + rgb2[0]*finalRGB[0], 255),
	    			  						  		min(green(pg.pixels[j*pg.width+i]) + rgb2[1]*finalRGB[1], 255),
	    			  						  		min(blue(pg.pixels[j*pg.width+i])  + rgb2[2]*finalRGB[2], 255));
	    		}else{
	    			pg.pixels[j*pg.width+i] = color(min(rgb[0], 255), 
	    											min(rgb[1], 255), 
	    											min(rgb[2], 255));	    	  
	    		}
			}
		}	
		
		//////////////////////////////  PIXELS ARE COLORED -> UPDATE THEM!!!
		pg.updatePixels();
		pg.endDraw();
		
		
		
		image(colors,width-rightDistance_+15,150,100,100);
		//////////////////////////////  DRAW METABALLS  
		image(pg,leftDistance_,upDistance_,width-rightDistance_,height-downDistance_);
		
		////////////////////////////// ENABLE THIS FOR ADDING AN IMAGE AS SURFACE
		
		//blend(back,0, 0, 600, 400, leftDistance_,upDistance_,width-rightDistance_,height-downDistance_,SOFT_LIGHT);
		

		int positionX = width-rightDistance_+65;
		int positionY = 200;
		int SqRad = (int) (45*45);
		
		if(mousePressed){			
			if((pow((positionX - mouseX),2) + pow((positionY - mouseY),2))<SqRad && motion){
				loadPixels();
				
				finalRGB[0] = (int) (red(pixels[width*mouseY+mouseX]));
				finalRGB[1] = (int) (green(pixels[width*mouseY+mouseX]));
				finalRGB[2] = (int) (blue(pixels[width*mouseY+mouseX]));
				updatePixels();
				fill(finalRGB[0],finalRGB[1],finalRGB[2]);
				stroke(0);
				ellipse(mouseX,mouseY,20,20);
			}
		}
		
		//////////////////////////////DRAW CURSOR ?!
		if(mouseX>width- (rightDistance_-leftDistance_) || mouseX< leftDistance_ || mouseY>height-(downDistance_-upDistance_) || mouseY<upDistance_){
			if((pow((positionX - mouseX),2) + pow((positionY - mouseY),2))<SqRad && motion && mousePressed){
				noCursor();
			}else{
				cursor(ARROW);
			}
			
		}else{			
			noCursor();
		}
		
		
		//////////////////////////////  DRAW INFO
		textAlign(LEFT);
		textSize(9);
		fill(255);
		text("FramesPerSecond: "+(int)frameRate + "  |  Updating Motion Blur every "+ updateFrame
				+ ". Frame  |  Deleting " + minus + "  |  Motion Blur is turned on: " + motion, 2, height-10 );
		
		//////////////////////////////  INCREMENT FRAMECOUNTER
		++frame;
	}


	public void keyPressed() {
		//////////////////////////////  BY PRESSING KEYS, BUTTONS ARE NOT AFFECTED...
		if (key=='+' && updateFrame<60){
	  		++updateFrame;
	  	}
	  	if (key=='-' && updateFrame>1){
	    	--updateFrame;
	  	}
	  
	 	if(key == 'm' && minus<255){
	 		minus += 20;
	 		if(minus>255){
	 			minus = 255;
	 		}
	 	}
	  
	  	if( key == 'n' && minus>0){
	  		minus -= 20;
	  		if(minus<0){
	  			minus = 0;
	  		}
	  	}
	  
	  	if( key == 'b'){
	  		motion = !motion;
	  	}
	  	if(key == 'r' && !releaseBall){				
			MetBall.releaseBalls(releaseBall);	
			releaseBall = true;
			releasedBalls = millis();
		}
	  
	  	if(key == 'd'){
		  	density = density%2;
		 	 density += 1;
	  	}
	  
	  	if(key == 'c'){
	  		masterMode = !masterMode;
	  	}
	  
	}
	
	public void controlEvent(ControlEvent theEvent) {
		ControllerInterface[] controllers = controlP5.getControllerList();
		switch(theEvent.controller().id()){
			case 0:
				motion = !motion;				
				if(((Button)theEvent.controller()).label().equals("Turn Blur on")){
					((Button)theEvent.controller()).setLabel("Turn Blur off");
					for(int i = 0; i<controllers.length; ++i){
						
							if(controllers[i].id()==1){
								controllers[i].setLabel("- Blur");
							}
							if(controllers[i].id()==2){
								controllers[i].setLabel("+ Blur");
							}
							
					}				
				}else{
					((Button)theEvent.controller()).setLabel("Turn Blur on");
					for(int i = 0; i<controllers.length; ++i){						
							if(controllers[i].id()==1){
								controllers[i].setLabel("activate Blur");
							}
							if(controllers[i].id()==2){
								controllers[i].setLabel("activate Blur");
							}						
					}
				}
				
				
				break;	
			case 1:				
				if(((Button)theEvent.controller()).label().equals("- Blur") && minus<255){
				    minus += 20;
				    if(minus>255){
				      minus = 255;
				    }					
				}
				break;
			case 2:
				if(((Button)theEvent.controller()).label().equals("+ Blur") && minus>0){
				    minus -= 20;
				    if(minus<0){
				      minus = 0;
				    }					
				}
				break;
			case 3:
				if(((Button)theEvent.controller()).label().equals("Turn Mouse on")){
					((Button)theEvent.controller()).setLabel("Turn Mouse off");
				}else{
					((Button)theEvent.controller()).setLabel("Turn Mouse on");
				}
				masterMode = !masterMode;
				break;
			case 4:
				if(!releaseBall){
					MetBall.releaseBalls(releaseBall);	
					releaseBall = true;
					releasedBalls = millis();
				}
				break;
		}
	}
	
	public void mouseReleased(){
		oldRGB = finalRGB;
	}
