/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ChartData;
import controlP5.ChartDataSet;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import java.util.ArrayList;
import processing.core.PApplet;

public class Chart
extends Controller {
    public static final int LINE = 0;
    public static final int BAR = 1;
    public static final int HISTOGRAM = 2;
    public static final int PIE = 3;
    public static final int AREA = 4;
    protected ArrayList<ChartDataSet> _myDataSet = new ArrayList();
    protected float resolution = 1.0f;
    protected float strokeWeight = 1.0f;

    protected Chart(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, int n, int n2) {
        super(controlP5, controllerGroup, string, f, f2, n, n2);
        this.addDataSet();
    }

    public ChartData addData(ChartData chartData) {
        return this.addData(0, chartData);
    }

    public ChartData addData(int n, ChartData chartData) {
        this.getDataSet(n).add(chartData);
        return chartData;
    }

    public ChartData addData(float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet().add(chartData);
        return chartData;
    }

    public ChartData addData(int n, float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(n).add(chartData);
        return chartData;
    }

    public ChartData addData(ChartDataSet chartDataSet, float f) {
        ChartData chartData = new ChartData(f);
        chartDataSet.add(chartData);
        return chartData;
    }

    public ChartData push(float f) {
        return this.push(0, f);
    }

    public ChartData push(int n, float f) {
        if ((float)this.getDataSet(n).size() > (float)this.width / this.resolution) {
            this.removeLast(n);
        }
        return this.addFirst(n, f);
    }

    public ChartData addFirst(float f) {
        return this.addFirst(0, f);
    }

    public ChartData addFirst(int n, float f) {
        ChartData chartData = new ChartData(f);
        this.getDataSet(n).add(0, chartData);
        return chartData;
    }

    public Chart removeLast() {
        return this.removeLast(0);
    }

    public Chart removeLast(int n) {
        return this.removeData(this.getDataSet(n).size() - 1);
    }

    public Chart removeData(ChartData chartData) {
        this.removeData(0, chartData);
        return this;
    }

    public Chart removeData(int n, ChartData chartData) {
        this.getDataSet(n).remove(chartData);
        return this;
    }

    public Chart removeData(int n) {
        this.removeData(0, n);
        return this;
    }

    public Chart removeData(int n, int n2) {
        if (this.getDataSet(n).size() < 1) {
            return this;
        }
        this.getDataSet(n).remove(n2);
        return this;
    }

    public ChartData setData(int n, ChartData chartData) {
        this.getDataSet().set(n, chartData);
        return chartData;
    }

    public ChartData setData(int n, int n2, ChartData chartData) {
        this.getDataSet(n).set(n2, chartData);
        return chartData;
    }

    public ChartDataSet addDataSet() {
        ChartDataSet chartDataSet = new ChartDataSet();
        this._myDataSet.add(chartDataSet);
        return chartDataSet;
    }

    public ChartDataSet setDataSet(ChartDataSet chartDataSet) {
        this.setDataSet(0, chartDataSet);
        return this.getDataSet();
    }

    public ChartDataSet setDataSet(int n, ChartDataSet chartDataSet) {
        this._myDataSet.set(n, chartDataSet);
        return chartDataSet;
    }

    public Chart removeDataSet(ChartDataSet chartDataSet) {
        this._myDataSet.remove(chartDataSet);
        return this;
    }

    public void removeDataSet(int n) {
        this._myDataSet.remove(n);
    }

    public ChartDataSet updateData(float[] fArray) {
        this.updateData(0, fArray);
        return this.getDataSet();
    }

    public ChartDataSet updateData(int n, float[] fArray) {
        int n2;
        if (this._myDataSet.get(n).size() != fArray.length) {
            this._myDataSet.get(n).clear();
            for (n2 = 0; n2 < fArray.length; ++n2) {
                this._myDataSet.get(n).add(new ChartData(0.0f));
            }
        }
        n2 = 0;
        this.resolution = (float)this.width / (float)(this._myDataSet.get(n).size() - 1);
        for (float f : fArray) {
            ((ChartData)this._myDataSet.get(n).get(n2++)).setValue(f);
        }
        return this.getDataSet(n);
    }

    public ChartDataSet getDataSet(int n) {
        return this._myDataSet.get(n);
    }

    public ChartDataSet getDataSet() {
        return this.getDataSet(0);
    }

    public ChartData getData(int n, int n2) {
        return (ChartData)this.getDataSet(n).get(n2);
    }

    public ChartData getData(int n) {
        return (ChartData)this.getDataSet().get(n);
    }

    public int size() {
        return this._myDataSet.size();
    }

    public void onEnter() {
    }

    public void onLeave() {
    }

    public void setValue(float f) {
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
    }

    public void setStrokeWeight(float f) {
        this.strokeWeight = f;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getResolution() {
        return (int)this.resolution;
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new ChartDisplay();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    class ChartDisplay
    implements ControllerDisplay {
        ChartDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.pushStyle();
            pApplet.fill(Chart.this.getColor().getBackground());
            pApplet.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            for (int i = 0; i < Chart.this.size(); ++i) {
                pApplet.stroke(Chart.this.getDataSet(i).getColor().getForeground());
                pApplet.strokeWeight((float)Chart.this.getDataSet(i).getStrokeWeight());
                pApplet.beginShape();
                for (int j = 0; j < Chart.this.getDataSet(i).size(); ++j) {
                    pApplet.vertex((float)j * Chart.this.resolution, (float)Chart.this.getHeight() - ((ChartData)Chart.this.getDataSet(i).get(j)).getValue());
                }
                pApplet.endShape();
            }
            pApplet.noStroke();
            pApplet.popStyle();
        }
    }
}

