import processing.video.*;

Capture webcam;

PImage prevFrame;
PImage bgImg;
PImage tempel;
int tol = 60;
int centerOfMoveX;
int centerOfMoveY;
int saveCount=0;


ArrayList<PVector> cMovePoints = new ArrayList<PVector>();
ArrayList<PVector> pMovePoints = new ArrayList<PVector>();

ArrayList<PVector> motionPoints = new ArrayList<PVector>();
String[] motionX = new String[0];
String[] motionY = new String[0];

int[][] memory = new int[64][48];
color[][] memoryColor = new int[64][48];
int maxMemory = 20;

void setup() {
  size(640, 480);

  frameRate(16);

  webcam = new Capture(this, width, height);
  webcam.start();
  prevFrame = createImage(webcam.width, webcam.height, RGB);
  bgImg = createImage(webcam.width, webcam.height, RGB);
  tempel = loadImage("dnt_1.png");
  tempel.resize(width, height);
}

void draw() {
  background(255);
  tint(255,80);
  image(tempel, 0, 0);
  //background(0);

  if (webcam.available() == true) {
    prevFrame = webcam.get(0, 0, webcam.width, webcam.height);
    webcam.read();
  }


  //if (keyPressed == true) {

  //  bgImg = webcam.get(0, 0, webcam.width, webcam.height);
  //}

  detectMotion();

  if (frameCount % 100 == 0) {
    saveMotion();
    if(frameCount % 200 == 0){
     tempel = loadImage("dnt_1.png");
    } else{
     tempel = loadImage("tempel_1.png");
    }
    tempel.resize(width,height);
  }
}


void detectMotion() {

 

  for (int x = 20; x < width-20; x+=5) {
    for (int y = 20; y < height-20; y+=5) {

      color cC = webcam.get(x, y);
      color pC = prevFrame.get(x, y);

      float d = dist(red(cC), green(cC), blue(cC), red(pC), green(pC), blue(pC));

      //if (d > tol*2) {
      //  //set(x, y, color(240, 27, 130));
      //  fill(240,27,130);
      //  rect(x-2,y-2,4,4);
      //}

      if (d > tol && d < tol*2) {
        fill(255);
        rect(x-2,y-2,4,4);
        //set(x, y, color(0));
        
        //noStroke();
        //ellipse(x,y,2,2);
      }

      //if (d < tol && d >50) {
      //  //set(x, y, color(0, 240, 240));
      //  fill(0,240,240);
      //  rect(x-2,y-2,4,4);
      //}
    }
  }
 
}

void saveMotion() {
  background(255);

  for (int x = 50; x < width-50; x+=10) {
    for (int y = 50; y < height-50; y+=10) {

      color cC = webcam.get(x, y);
      color pC = prevFrame.get(x, y);

      float d = dist(red(cC), green(cC), blue(cC), red(pC), green(pC), blue(pC));

      if (d > tol && d < tol*2) {
        motionX = append(motionX, str(x));
        motionY = append(motionY, str(y));
        fill(255, 0, 0);
        noStroke();
        ellipse(x, y, 4, 4);
      }
    }
  }
  String[] postDate = {str(year())+"_"+str(month())+"_"+str(day())+"_"+str(hour())+"_"+str(minute())};
  
  saveStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/motionX_"+saveCount+".txt", motionX);
  saveStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/motionY_"+saveCount+".txt", motionY);
  saveStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/postDate_"+saveCount+".txt", postDate);


  saveCount++;

  motionX = new String[0];
  motionY = new String[0];
}


void mousePressed() {
  println(mouseX); 
  saveFrame("testing_####.png");
}
