class SwankAgent {
  //Attributes
  PVector location;
  PVector prevLocation;
  float size;
  float speed;
  color c;
  color col;
  PImage don;

  ArrayList<PVector>lines = new ArrayList<PVector>();

  //Constructor
  SwankAgent(PVector _location, float _speed) {
    location = _location;
    speed = _speed;
  }

  //Functions
  PVector update() {
    moveImageDir(PI);
    return(location);
  }


  void moveImageDir(float scale) {
    float angle = ((blue(currentImage.get((int)location.x, (int)location.y))/255.0))*scale;
    prevLocation = location;
    location = new PVector(location.x + sin(angle)*speed, location.y + cos(angle)*speed);
    checkBorder();
    stroke(0);
  }


  void checkBorder() {
    if (location.y<100) {
      if (speed>100) {
        location.y = speed;
      } else {
        location.y = 120;
      }
    }

    if (location.y> height-40) {      
      if (speed>40) {
        location.y = height- speed;
      } else {
        location.y = width - 30;
      }
    }

    if (location.x < 40) {
      if (speed>40) {
        location.x = speed;
      } else {
        location.x = 60;
      }
    }

    if (location.x > width-10) {
      if (speed>10) {
        location.x = width - speed;
      } else {
        location.x = width - 30;
      }
    }
  }
}
