import hpglgraphics.*;
import processing.serial.*;
import cc.arduino.*;

Serial plotterSerial;
Serial leverSerial;
HPGLGraphics hpgl;



PVector webcamSize = new PVector(640, 480);

/* -- Plotter Document Information --
 1 plotter unit = .02488 mm
 plotter units will be converted from document size,
 so output / canvas should represent ratio of either A4 or A3,
 corresponding to declared document size
 
 ___ A4 ___
 Maximum Plotting Dimensions ( X = 0 - 11040, Y = 0 - 7721)
 0,0 point is lower left hand corner of landscape paper
 being set into printer
 */
PVector a4Size = new PVector(1104, 772);

/*

 ___ A3 ___
 Maximum Plotting Dimensions ( X = 0 - 16158, Y = 0 - 11040)
 0,0 point is upper left hand corner of portait paper
 being set into printer (still prints landscape orientation)
 
 */
PVector a3Size = new PVector(1616, 1104);

PVector a4FinalPoint = new PVector(width-10, 10);
PVector a3FinalPoint = new PVector(width-10, height-10);


//margin values should be switched based on A3 or A4 document size
//currently set for A3 size
int Xmargin = 10;
int Ymargin = 50;

//Array Container for HPGL commands given to plotter
String[] plotCommands = new String[0];
//Count for determining how many plotting sequences have been passed
//and additionally determining when the lever should reset the document size
int commandsCount = 0;
int runFrames = 0;

//seconds of delay between plotting sequences
float secondsDelay = 20;
int delay ;
//delayCount increases until it hits the secondsDelay
int delayCount = 0;
int timePoint;


//currentImage is the image loaded to be processed
//runningImages is a set of the images which have been loaded
PImage currentImage;
ArrayList<PImage> runningImages = new ArrayList<PImage>();
int imgCount = 0;
int tempelCount = 0;
int dntCount = 0;

//arrays of the PVectors and Agents 
//for starting points in generative operation
//and continuous draw
PVector[] polyline = new PVector[0];
ArrayList<SwankAgent> swankAgents = new ArrayList<SwankAgent>();

//pen number for pen selection
int penNum;

//Booleans for switching in and out of printing / inbetween operations
Boolean runCommands = false;
Boolean loadCommands = false;
Boolean delayBool = false;
Boolean reload = false;
Boolean resetLever = false;

//ticker for coordinating the uploading of motionX and motionY point files
int saveCount=0;

void settings() {
  size((int)webcamSize.x, (int)webcamSize.y);
}

void setup() {
  //keep frame rate low - highest limit should be 16 for plotter
  frameRate(6);
  //see function below for additional info
  HPGLload();
  //see function below for additional info
  plotterFirstBreath();
  serialLoad();
  //leverSerial.write("s"+270);

  plotterSerial.write("IN;SP1;");

  //--initiate static variables
  delay = floor(frameRate*secondsDelay);
  //serialStart();
}

void draw() {
  
  if(frameCount < 24){
   leverSerial.write("s"+270); 
  }

  // if the frameCount is 24 (or if the code has just been started)
  // or if the sequence should be reloaded
  // these operations prepare for each sequenced
  if (frameCount == 24 || reload == true) {
    swankSequence();
    timePoint = frameCount+8;
    reload = false;
    serialStart();
  }


  // when the reload has been set and 1 second has passed,
  // the hpgl file is loaded as string commands
  // the commandsCount is increased,
  // and the Boolean to begin running the command is set to true
  if (frameCount == timePoint) {
    loadCommands();
    commandsCount++;
    runCommands = true;
  }



  if (runCommands == true) {
    if (runFrames<plotCommands.length-1) {
      plotterSerial.write(plotCommands[runFrames]);
      println(plotCommands[runFrames]);
    }
    runFrames++;

    if (runFrames>=plotCommands.length) {
      clearCommands();
      runCommands = false;
      delayBool = true;
      resetLever = true;
    }

    if (runFrames>=plotCommands.length-2) {
      saveFrame(imgCount+"-"+year()+day()+minute()+".png");
    }
  }


  if (delayBool == true) {
    delayCount++;
    if (delayCount == delay) {
      delayBool = false;
      reload = true;
      delayCount = 0;
    }
  }

  if (resetLever == true) {
    if (imgCount % 2 == 1) {
    } else {
      throwLever();
    }
    resetLever = false;
  }
  println(runFrames);
  println(plotCommands.length);
}



//Instanced Functions

// switch "A3" and "A4" to change between document size
void HPGLload() {
  hpgl = (HPGLGraphics) createGraphics(width, height, HPGLGraphics.HPGL);
  hpgl.setPaperSize("A4");
}


// switch the COM7 and COM4 as necessary to match the port of the printer
// and the port of the arduino component. 
// On macs, this port name will appear differently, but on
// windows they should be all a combination of COM with #s
void serialLoad() {
  leverSerial = new Serial(this, "COM4", 9600);
}

void plotterFirstBreath() {
  plotterSerial = new Serial(this, "COM7", 9600, 'N', 16, 1.0);
  plotterSerial.write("IN;");
}

//initiates Serial for plotter
void serialStart() {
  plotterSerial.write("IN;");
}

//places new currentImage, begins writing of .hpgl file, processes image
//ends writing .hpgl file for current phase
void swankSequence() {
  setCurrentImage();
  HPGLsetPathBegin();
  processImage(penNum);
}

// sets the path for saving the .hpgl file commands
// and begins frame in which Processing actions are recorded into hpgl format
void HPGLsetPathBegin() {
  hpgl.setPath("InputCommand_" + commandsCount + ".hpgl");
}

//clears currentImage and swankAgents arrayList 
//sets new currentImage
//change naming convention as necessary
//if looping must also be changed if more locations for input are added 
//to the two locations mentioned below
void setCurrentImage() {
  clearSwankArray(swankAgents);
  currentImage = null;
  if (imgCount % 2 == 0) {
    currentImage = loadImage("tempel_1.png");
    penNum = 1;
    tempelCount++;
    println("tempel");
  } else {
    currentImage = loadImage("dnt_1.png");
    penNum = 2;
    dntCount++;
    println("dnt");
  }
  currentImage.resize(width, height);
  runningImages.add(currentImage);
  imgCount++;
}


//section of code which processes the image
//first a grid of points are analyzed, and the starting points are
//evaluated based on image criteria (brightness in the case below)
//swankAgents are created and added to an arrayList
//swankAgents are updated based on the runCount,
//which determines how many processes are run

//many of these items can be parametricized,
//leading to a wider variety of change,
//but only a limited amount of parametricization
//is currently used
void processImage(int _pen) {

  uploadPoints();


  String[] postDate = loadStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/postDate_"+saveCount+".txt");


  int runCount = ceil(400/(swankAgents.size()+1)+1);
  if (runCount > 15) runCount = 15;

  beginRecord(hpgl);

  hpgl.selectPen(_pen);
  println(swankAgents.size());
  updateSwank(runCount);

  textSize(15);
  text(postDate[0], 100, height-1);
  //text("N G Z C M | P 3 | 7 4 7 5 A", width-200, height-1);

  endRecord();
  saveCount++;
}

void loadCommands() {
  plotCommands = loadStrings("InputCommand_"+ commandsCount + ".hpgl");
  //for (int i = plotCommands.length-1; i > 0; i--) {
  //  plotCommands[i] = plotCommands[i-1];
  //}
}

void clearSwankArray(ArrayList<SwankAgent> array) {
  for (int i = array.size()-1; i > -1; i--) {
    array.remove(i);
  }
}

void clearCommands() {    
  plotCommands = new String[0];
  runFrames = 0;
}

void throwLever() {
  for (int i = 270-1; i > 0; i--) {
    leverSerial.write("s"+i);
  }
  for (int i = 0; i < 270; i++) {
    leverSerial.write("s"+i);
  }
  resetLever = false;
}

void uploadPoints() {

  File tempFile = new File("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/motionX_"+saveCount+".txt"); 
  if (tempFile.exists()) {
    String[] tempHolderX = loadStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/motionX_"+saveCount+".txt");
    String[] tempHolderY = loadStrings("C:/Users/grays/Desktop/CODING/PlotterContinousRun_skeleton/motionY_"+saveCount+".txt");

    float scale;

    for (int i = 0; i < tempHolderX.length; i++) {
      scale = map(brightness(currentImage.get(int(tempHolderX[i]),int(tempHolderY[i]))),0,255,5,90);
      swankAgents.add(new SwankAgent(new PVector(int(tempHolderX[i]), int(tempHolderY[i])), scale));
    }
  }
}

void updateSwank(int run) {
  for (int i = 0; i < swankAgents.size(); i++) {
    beginShape();
    for (int j = 0; j < run; j++) {
      PVector t = swankAgents.get(i).update();
      vertex(t.x, t.y);
    }
    endShape(OPEN);
  }
}
