/* function that draws the ball & the paddles, moves the ball & calls the function for the navigation of the paddles */
void drawElements(){
  /* draw the elements */
  fill(transWhite);                                                                       // define the color
  ellipse(ballPos.x, ballPos.y, diameter, diameter);                                      // draw the ball
  rect(paddlePosLeft.x, paddlePosLeft.y, paddleSize.x, paddleSize.y, paddleSize.z);       // draw the left paddle
  rect(paddlePosRight.x, paddlePosRight.y, paddleSize.x, paddleSize.y, paddleSize.z);     // draw the right paddle
  
  /* move the ball */
  ballPos.add(ballVel);
  
  /* create a border (ball can't get out at the top or bottom) */
  if(ballPos.y - diameter/2 <= 0 || ballPos.y + diameter/2 >= h){
    ballVel.y *= -1;                                   // change in direction on the y-axis
  }
  
  /* call the function that moves the paddles */
  navigatePaddles();
  
  /* play back the ball (paddle hits the ball) – QUESTION: WHY DOES IT NOT WORK WHEN THE X-POSITION OF THE BALL SHOULD EQUAL (==) THE X-POSITION OF THE PADDLE?  */
  if(ballPos.x - diameter/2 <= paddlePosLeft.x + paddleSize.x &&             // ball hits left paddle
     ballPos.y >= paddlePosLeft.y &&
     ballPos.y <= paddlePosLeft.y + paddleSize.y ||
     ballPos.x + diameter/2 >= paddlePosRight.x &&                           // ball hits right paddle
     ballPos.y >= paddlePosRight.y &&
     ballPos.y <= paddlePosRight.y + paddleSize.y){
       ballVel.x *= -1;                                                      // change in direction on the x-axis
  }
   
  /* left paddle doesn't hit the ball */
  if(ballPos.x + diameter <= 0){
    /* count points */
    scoreLeft += 1;

    /* throw-in of ball */
    ballDirection();
    ballPos = new PVector(w/2, random(diameter, h - diameter));
  }
  
  /* right paddle doesn't hit the ball*/
  if(ballPos.x - diameter >= w){
    /* count points */
    scoreRight += 1;
    
    /* throw-in of ball */
    ballDirection();
    ballPos = new PVector(w/2, random(diameter, h - diameter));
  }
  
  /* write the score */
  textSize(mediumFont);
  text(scoreLeft, 100, 100);
  text(scoreRight, w-100, 100);
  
  /* end game when score of ten is reached */
  if(scoreLeft == 3){ 
      noLoop();
      textSize(bigFont);
      text(textLeft, w/2, h/2 - 30);
      textSize(smallFont);
      text(playAgain, w/2, h/2 + 30);
  }else if(scoreRight == 3){
      noLoop();
      textSize(bigFont);
      text(textRight, w/2, h/2 - 30);
      textSize(smallFont);
      text(playAgain, w/2, h/2 + 30);
  }
}
