/*

Pong 2.0

Lydia Kluge, January 2014
Bauhaus-University Weimar
lydia.kluge@uni-weimar.de

This sketch is distributed under the Creative Commons Atrribution-NonCommercial-ShareAlike 4.0 License (see: creativecommons.org/licenses/by-nc-sa/4.0/).
Feel free to share or adapt the written program as long as you give credit to me,
provide a link to the license, indicate if changes were made and don't use it for commercial purposes.
If you remix, transform or build upon my sketch, you must distribute your contributions under the same license.

This Sketch recreates the famous game "Pong"; to touch my hat to the old pong consoles I used an
Arduino and two potentiometers to navigate the paddles. (On the Arduino runs the "StandartFirmata"-Sketch.)

How To Use:
After the tangible interface (read: Arduino and the potentiometers) is attached,
simply turn the right potentiometer to move the right paddle and turn the left one
to move the left paddle.

*/

/* import the Arduino (Firmata) Library */
import org.firmata.*;
import cc.arduino.*;

/* import serial library */
import processing.serial.*;

/* variables for the size of the canvas */
int w = 1400;
int h = 900;

/* variables for the color of the background */
color yellow1 = color(255, 170, 0);
color yellow2 = color(255, 209, 64);
PImage bg = createImage(w, h, RGB);                        // manually drawn background

/* variable for the color of the paddles & the ball */
color transWhite = color(255, 200);

/* vectors for the size & position of the paddles */
PVector paddleSize = new PVector(17, 90, 2);              // z-component is used for storing the value for the radius of the corners
PVector paddlePosLeft = new PVector(35, random(h - paddleSize.y));
PVector paddlePosRight = new PVector(w - 35 - paddleSize.x, random(h - paddleSize.y));

/* object for the navigation of the paddles */
Arduino paddles;

/* variables & vectors for the size, position & velocity of the ball */
short diameter = 20;
PVector ballPos = new PVector(w/2, random(diameter, h - diameter));
PVector ballVel = new PVector(5, 5);
byte ballVelDir;

/* variables for counting the score */
short scoreLeft = 0;
short scoreRight = 0;

/* class for loading a font & variables for the size & content of the text */
PFont museo;
short bigFont = 90;
short mediumFont = 75;
short smallFont = 55;
String textLeft = "LEFT SIDE LOST.";
String textRight = "RIGHT SIDE LOST.";
String playAgain = "CLICK TO PLAY AGAIN.";

/* configuration */
void setup(){
  size(w, h);
  noStroke();
  smooth();
  
  /* load & style the font */
  museo = loadFont("Museo-700-90.vlw");
  textFont(museo);
  textAlign(CENTER);
  fill(transWhite);
  
  /* call the function that draws an image with a color gradient (used for the background) */
  backgroundGradient();
  
  /* call the function that determines the direction in which the ball initially moves */
  ballDirection();
 
  /* fill the paddle-object with data */
  paddles = new Arduino(this, "/dev/tty.usbmodem1411", 57600);
}

/* loop */
void draw(){
  /* draw the background image */
  image(bg, 0, 0);
  
  /* call the function that draws & moves the ball & the paddles */
  drawElements();
}

/* mouse button is clicked */
void mousePressed(){
  /* restart game */
  setup();
  draw();
  loop();
}

/*

Yay! Done.

*/
