/* DRAW A CHART FROM EXTERNAL DATA
 * 
 * Imports a data table from a textfile
 * with tab seperated values (tsv). These
 * formats are very common when exporting
 * spreadsheets from Excel or similar software.
 * Make sure that the file "measurements.tsv"
 * exists in the data folder of this sketch.
 *
 * The Table class is written by Ben Fry:
 * http://benfry.com/writing/archives/3
 * It handles the import and access to the data.
 * 
 * Frederic Gmeiner, 2011
 */


// create a variable of the type Table:
Table dataTable;
// variable to store the total number of rows of the table document:
int rowCount;


void setup(){

  size(300,300);
  noStroke();
  
  // initialize a new table object from the file "measurements.tsv" 
  // in your data folder. Assign this new object to the variable dataTable: 
  dataTable = new Table("measurements.tsv");
  // get and store the total number of rows:
  rowCount = dataTable.getRowCount();
}

void draw(){

// iterate over all rows of the table:
for (int row = 0; row < rowCount; row++) {
    
    // For each row get the data of the columns
    // and store them in a variable:
    String date = dataTable.getString(row, 0);
    int hour = dataTable.getInt(row, 1);
    int minute = dataTable.getInt(row, 2);
    float value = dataTable.getFloat(row, 3);
    
    // Print the row to the console by combining
    // the variables with text to make it more readable:
    println(date + ": " + hour +"h" + minute + "m - " + value);
     
     // set the fill color to the value of the current row:
     fill(value);
     // draw the bar with the appropriate height:
     rect((width/rowCount)*row,height-value,width/rowCount,value);
     
  }
  // print a line to make it easier to read the output in the console:
  println("------");

}
