﻿
public var RemoteIP : String = "kosmos.medien.uni-weimar.de"; //127.0.0.1 signifies a local host (if testing locally
public var SendToPort : int = 1065; //the port you will be sending from
public var ListenerPort : int = 1065; //the port you will be listening on
public var controller : Transform;
public var gameReciever1 = "You_Object_Name";
public var gameReciever2 = "You_Object_Name";

private var handler : Osc;

//VARIABLES YOU WANT TO BE ANIMATED
private var x1 : float = 0;
private var y2 : float = 0;
private var z1 : float = 0;

private var x2 : float = 0;
private var y2 : float = 0;
private var z2 : float = 0;


public function Start ()
{
    //Initializes on start up to listen for messages
    //make sure this game object has both UDPPackIO and OSC script attached

    var udp : UDPPacketIO = GetComponent("UDPPacketIO");
    udp.init(RemoteIP, SendToPort, ListenerPort);

    handler = GetComponent("Osc");
    handler.init(udp);
    handler.SetAllMessageHandler(AllMessageHandler);

    //var msg = handler.StringToOscMessage("/configure/port " + ListenerPort); 
    //handler.Send(msg);

    updateSubscriptions();


}

function OnDisable()
{
    // close UDP socket of the listener

    Debug.Log("Closing UDP socket");

    handler.Cancel();
    handler = null;

}

Debug.Log("Running");

function updateSubscriptions() {

    Debug.Log("Updating subscriptions ...");



    msg = handler.StringToOscMessage("/subscribe/yourname/blender/Root/vector 50.0 0.0 20.0"); 
    handler.Send(msg);

    msg = handler.StringToOscMessage("/subscribe/yourname/blender/Root/vector 50.0 0.0 20.0"); 
    handler.Send(msg);
}

function Update () {

    var person1 = GameObject.Find(gameReciever1);
    var person2 = GameObject.Find(gameReciever2);
  

    person1.transform.position = Vector3(x1, z1, y1);
    person2.transform.position = Vector3(x2, z2, y2);
   

    //updateSubscriptions();

    // re-subscribe every 60 frames
    
    if(Time.frameCount % 60 == 1) {
        updateSubscriptions();  
    }
    
}

//These functions are called when messages are received
//Access values via: oscMessage.Values[0], oscMessage.Values[1], etc

public function AllMessageHandler(oscMessage: OscMessage){

    var msgString = Osc.OscMessageToString(oscMessage); //the message and value combined
    var msgAddress = oscMessage.Address; //the message parameters
    var values = oscMessage.Values;
    Debug.Log(msgString); //log the message and values coming from OSC
  
    //FUNCTIONS YOU WANT CALLED WHEN A SPECIFIC MESSAGE IS RECEIVED
    switch (msgAddress){

     
        case "/yourname/blender/Root/vector":
            x1 = values[0];
            y2 = values[1];
            z1 = values[2];
            break;

        case "/yourname/blender/Root/vector":
            x2 = values[0];
            y2 = values[1];
            z2 = values[2];
            break;

        default:
            //
            break;
    }
    
}


    //FUNCTIONS CALLED BY MATCHING A SPECIFIC MESSAGE IN THE ALLMESSAGEHANDLER FUNCTION
    public function Rotate(msgValue) : void //rotate the cube around its axis
    {
        yRot = msgValue;
    }

