
public var RemoteIP : String = "127.0.0.1"; //127.0.0.1 signifies a local host (if testing locally
public var SendToPort : int = 9000; //the port you will be sending from
public var ListenerPort : int = 8050; //the port you will be listening on
public var controller : Transform;
public var gameReceiver1 = "Asha";
public var gameReceiver2 = "Martin";
private var handler : Osc;

//VARIABLES YOU WANT TO BE ANIMATED
public var x1 : float = 0;
public var y1 : float = 0;
public var z1 : float = 0;

public var x2 : float = 0;
public var y2 : float = 0;
public var z2 : float = 0;

public function Start ()
{
	//Initializes on start up to listen for messages
	//make sure this game object has both UDPPackIO and OSC script attached

	var udp : UDPPacketIO = GetComponent("UDPPacketIO");
	udp.init(RemoteIP, SendToPort, ListenerPort);
	handler = GetComponent("Osc");
	handler.init(udp);
	handler.SetAllMessageHandler(AllMessageHandler);

	var msg = handler.StringToOscMessage("/configure/port 1234"); 
	handler.Send(msg);



}

Debug.Log("Running");

function Update () {

	var go1 = GameObject.Find(gameReceiver1);
	var go2 = GameObject.Find(gameReceiver2);

	go1.transform.position = Vector3(x1, z1, y1);
	go2.transform.position = Vector3(x2, z2, y2);

	// re-subscribe every 600 frames
	if(Time.frameCount % 15 == 1) {

		Debug.Log("Updating subscriptions ...");

		msg = handler.StringToOscMessage("/subscribe/Asha-neon-green-socks/blender/Root/vector 50.0 0.0 10.0");
		handler.Send(msg);

		msg = handler.StringToOscMessage("/subscribe/Martin-left-red-right-violet/blender/Root/vector 50.0 0.0 10.0"); 
		handler.Send(msg);

	}


}

//These functions are called when messages are received
//Access values via: oscMessage.Values[0], oscMessage.Values[1], etc

public function AllMessageHandler(oscMessage: OscMessage){


	var msgString = Osc.OscMessageToString(oscMessage); //the message and value combined
	var msgAddress = oscMessage.Address; //the message parameters
	var values = oscMessage.Values;
	Debug.Log(msgString); //log the message and values coming from OSC

	//FUNCTIONS YOU WANT CALLED WHEN A SPECIFIC MESSAGE IS RECEIVED
	switch (msgAddress){

		case "/Asha-neon-green-socks/blender/Root/vector":
			x1 = values[0];
			y1 = values[1];
			z1 = values[2];
			Debug.Log(x1 + " " + y1 + " " + z1);
			break;
		case "/Martin-left-red-right-violet/blender/Root/vector":
			x2 = values[0];
			y2 = values[1];
			z2 = values[2];
			Debug.Log(x2 + " " + y2 + " " + z2);
			break;
		default:
			//
			break;
	}

}


//FUNCTIONS CALLED BY MATCHING A SPECIFIC MESSAGE IN THE ALLMESSAGEHANDLER FUNCTION
public function Rotate(msgValue) : void //rotate the cube around its axis
{
	yRot = msgValue;
}

