﻿
public var RemoteIP : String = "kosmos.medien.uni-weimar.de"; //127.0.0.1 signifies a local host (if testing locally
public var SendToPort : int = 1065; //the port you will be sending from
public var ListenerPort : int = 1065; //the port you will be listening on
public var controller : Transform;
public var hips = "hips";
public var head = "head";

private var handler : Osc;

//VARIABLES YOU WANT TO BE ANIMATED
private var hips_x : float = 0;
private var hips_y : float = 0;
private var hips_z : float = 0;

private var head_x : float = 0;
private var head_y : float = 0;
private var head_z : float = 0;


public function Start ()
{
    //Initializes on start up to listen for messages
    //make sure this game object has both UDPPackIO and OSC script attached

    var udp : UDPPacketIO = GetComponent("UDPPacketIO");
    udp.init(RemoteIP, SendToPort, ListenerPort);

    handler = GetComponent("Osc");
    handler.init(udp);
    handler.SetAllMessageHandler(AllMessageHandler);

    //var msg = handler.StringToOscMessage("/configure/port " + ListenerPort); 
    //handler.Send(msg);

    updateSubscriptions();


}

function OnDisable()
{
    // close UDP socket of the listener

    Debug.Log("Closing UDP socket");

    handler.Cancel();
    handler = null;

}

Debug.Log("Running");

function updateSubscriptions() {

    Debug.Log("Updating subscriptions ...");



    msg = handler.StringToOscMessage("/subscribe/yourname/blender/Root/vector 50.0 0.0 20.0"); 
    handler.Send(msg);

    msg = handler.StringToOscMessage("/subscribe/yourname/blender/Head/vector 50.0 0.0 20.0");
    handler.Send(msg);
}

function Update () {

    var move_hips = GameObject.Find(hips);
    var move_head = GameObject.Find(head);
  

    move_hips.transform.position = Vector3(hips_x, hips_z, hips_y);
    move_head.transform.position = Vector3(head_x, head_z, head_y);
   

    //updateSubscriptions();

    // re-subscribe every 60 frames
    
    if(Time.frameCount % 60 == 1) {
        updateSubscriptions();  
    }
    
}

//These functions are called when messages are received
//Access values via: oscMessage.Values[0], oscMessage.Values[1], etc

public function AllMessageHandler(oscMessage: OscMessage){

    var msgString = Osc.OscMessageToString(oscMessage); //the message and value combined
    var msgAddress = oscMessage.Address; //the message parameters
    var values = oscMessage.Values;
    Debug.Log(msgString); //log the message and values coming from OSC
  
    //FUNCTIONS YOU WANT CALLED WHEN A SPECIFIC MESSAGE IS RECEIVED
    switch (msgAddress){

     
        case "/yourname/blender/Root/vector":
            hips_x = values[0];
            hips_y = values[1];
            hips_z = values[2];
            break;

        case "/yourname/blender/Head/vector":
            head_x = values[0];
            head_y = values[1];
            head_z = values[2];
            break;

        default:
            //
            break;
    }
    
}


    //FUNCTIONS CALLED BY MATCHING A SPECIFIC MESSAGE IN THE ALLMESSAGEHANDLER FUNCTION
    public function Rotate(msgValue) : void //rotate the cube around its axis
    {
        yRot = msgValue;
    }

