var mainnavAElements = document.querySelectorAll('.mainnav a'); // document.querySelectorAll() gibt ein "Array" aus. (vgl. https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Values,_variables,_and_literals#Array_literals)
var containerElement = document.querySelector('.container');

function scrollTo(id) {
  var left = (id - 1) * -100; // Rechenbeispiel (id = 3): (3-1)*-100 = -200
  containerElement.style.left = left+'%'; // Das Element wird um "left"% (z.B. -200%) nach links verschoben.
}

// Jedem Array-Element (mainnavAElements) wird ein eventListener hinzugefügt.
// (vgl. https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Statements#for_Statement)
for (var i = 0; i < mainnavAElements.length; i++) {
  var mainnavAElement = mainnavAElements[i]; 
  mainnavAElement.addEventListener('click',function(){
    var id = this.dataset.id; // das Argument "data-id" wird von dem geklicktem Element ("this") ausgelesen
    scrollTo(id); // die Funktion scrollTo wird aufgerufen, die "id" wird übergeben.
  });
};