class Segmente {
  
  float x; // X-Position
  float y; // Y-Position
  
  int seg; // Segmentzähler
  int r; // Radius
  float g; // Richtung bzw. Grad
  
  boolean mouseOver; //Maus über dem Objekt
  boolean visible; //Objekt sichtbar
  boolean move; //Objekt bewegt sich
  
  int h,s,b,a; // Farbe HSB und Alpha
  
  float sx,sy; //Geschwindigeit
  
  Segmente() {
    //println("Segmente erstellt!");
    x = random(100,width-100);
    y = random(100,height-100);
    
    seg = (int)random(6);
    r = 100;
    g = 90; // Richtung nach oben
    
    h = (int)random(360);
    s = 100;
    b = 100;
    a = 100;
    
    mouseOver = false;
    visible = true;
    move = false;
    
    sx = 5;
    sy = 5;
  }
  
  void maleSegmente() {
    fill(h,s,b,a);
    maleSegmente(seg,r,g,x,y);
  }
  
  //abgewandelte Funktion aus dem Buch "Generative Gestaltung" Seite 187
  void maleSegmente(int seg,int r,float g,float x,float y) {
    float segmentzahl = 3 + (float)seg;
    float angleStep = 360/segmentzahl;
    //zeichnet Linien über die berechneten Punkte auf der äußeren Kreisbahn
    beginShape();
    vertex(x, y); 
    for (float angle=0; angle<=360; angle+=angleStep) {
      float vx = x + cos(radians(angle-g))*r;
      float vy = y + sin(radians(angle-g))*r;
      vertex(vx, vy);
    }
    vertex(x + cos(radians(360-g))*r, y + sin(radians(360-g))*r);
    endShape();
  }
}
