Segmente[] objekt = new Segmente[9];

void setup() {
  size(800, 800);
  smooth();
  noStroke();
  //frameRate(25);
  colorMode(HSB,360,100,100,100);
  
  for (int i=0; i < objekt.length; i++) {
    objekt[i] = new Segmente(); //Konstrukror
  }
}

void draw() {
  background(0);
  //male die Objekte nur wenn sie aktiviert bzw. sichtbar sind
  for (int i=0; i < objekt.length; i++) {
    if (objekt[i].visible) {
      objekt[i].maleSegmente();
    }
  }
  //prüfe ob die Maus über dem Objekt ist
  for (int i=0; i < objekt.length; i++) {
    if ((mouseX >= objekt[i].x-objekt[i].r) && (mouseX <= objekt[i].x+objekt[i].r) && (mouseY >= objekt[i].y-objekt[i].r) && (mouseY <= objekt[i].y+objekt[i].r)) {
      objekt[i].mouseOver = true;
    }else {
      objekt[i].mouseOver = false;
    }
  }
}

void mouseDragged() { //verändere die Position des ausgewählten Objekts
  for (int i=0; i < objekt.length ; i++) {
    if (objekt[i].mouseOver) {
      objekt[i].x = mouseX;
      objekt[i].y = mouseY;
      break;
    }
  }
}

void keyPressed() {
  int k = (int)key-48-1; //Zahlenverschiebung: '1' entspricht objekt[0]
  //aktiviere bzw. mache das Objekt mit der jeweiligen Zahl sichtbar
  if ((k >= 0) && (k < objekt.length)) {
    if (objekt[k].visible == false) {
      objekt[k].visible = true;
    }else if (objekt[k].visible) { //oder wieder unsichtbar
      objekt[k].visible = false;
    }
  }
  //verändere die Segmentzahl oder Farbe des ausgewählten Objekts (UP,DOWN,LEFT,RIGHT)
  if (key == CODED) {
    for (int i=0; i < objekt.length; i++) {
      if (objekt[i].mouseOver) {
        if (keyCode == UP) {
          if (objekt[i].seg <= 100) {
            objekt[i].seg += 1;
          }
        }
        if (keyCode == DOWN) {
          if (objekt[i].seg >= 1) {
            objekt[i].seg -= 1;
          }
        } 
        if (keyCode == RIGHT) {
          if (objekt[i].h <= 360) {
            objekt[i].h += 1;
          }
        }
        if (keyCode == LEFT) {
          if (objekt[i].h >= 1) {
            objekt[i].h -= 1;
          }
        }
      }
    }
  }
  //verändere Radius (+,-), Alphawert (,,.) und Gradzahl bzw. Richtung (/,*) des Objekts
  for (int i=0; i < objekt.length; i++) {
    if (objekt[i].mouseOver) {
      if (key == '+') {
        if (objekt[i].r <= 200) {
          objekt[i].r += 1;
        }
      }
      if (key == '-') {
        if (objekt[i].r >= 50) {
          objekt[i].r -= 1;
        }
      } 
      if (key == ',') {
        if (objekt[i].a <= 100) {
          objekt[i].a += 1;
        }
      }
      if (key == '.') {
        if (objekt[i].a >= 10) {
          objekt[i].a -= 1;
        }
      }
      if (key == '/') {
        if (objekt[i].g <= 360) {
          objekt[i].g += 1;
        }
      }
      if (key == '*') {
        if (objekt[i].g >= 1) {
          objekt[i].g -= 1;
        }
      }
    }
  }
  //erzeuge Zufallswerte bei allen Objekten (ENTER)  
  if (key == ENTER || key == RETURN) {
    for (int i=0; i < objekt.length; i++) {
      objekt[i].x = random(width);
      objekt[i].y = random(height);
      //bessere Verteilung der Werte bzw. weniger Kreise
      switch((int)random(4)) {
        case 0:
          objekt[i].seg = (int)random(6);
          break;
        case 1:
          objekt[i].seg = (int)random(6,12); 
         break; 
        case 3:
          objekt[i].seg = (int)random(12,100);
          break;
        default:
          break;
      }
      objekt[i].r = (int)random(50,100);
      objekt[i].g = random(360);
      
      objekt[i].h = (int)random(360);
      objekt[i].a = (int)random(50,100);
    }
  }
  //aktiviere die Bewegung aller Objekte (0)
  for (int i=0; i < objekt.length; i++) {
    if ((key == '0') && (objekt[i].move == false)) {
      objekt[i].move = true;
    }else if ((key == '0') && (objekt[i].move)) { //oder deaktiviere sie
      objekt[i].move = false;
    }
  }
}

void mouseMoved() { //bewege alle Objekte, außer das ausgewählte, frei im Raum
  for (int i=0; i < objekt.length; i++) {
    if ((objekt[i].move == true) && (objekt[i].mouseOver == false)) {
      objekt[i].x = objekt[i].x + objekt[i].sx;
      objekt[i].y = objekt[i].y + objekt[i].sy;
      //drehe das Objket
      objekt[i].g = objekt[i].g + 1;
      if (objekt[i].g >= 360) {
        objekt[i].g = 0;
      }
      //wechsel die Bewegungsrichtung, wenn das Objekt an den Rand stößt
      if (objekt[i].x >= width || objekt[i].x <= 0){
        objekt[i].sx = -objekt[i].sx;
      }
      if (objekt[i].y >= height || objekt[i].y <= 0){
        objekt[i].sy = -objekt[i].sy;
      }
    }
  }
}

