<h2>Authentication</h2>
<p>
Authentication gibt deiner Anwendung die Möglichkeit, die Identität eines Facebook-Nutzers zu erkennen, und Daten via Facebooks APIs zu schreiben und zu auszulesen.
</p>

<h2>Clientseitig (Javascript)</h2>

<h3>Code</h3>
<pre>
<?php echo htmlentities('<div id="fb-root"></div>
<script>
  // Load the SDK Asynchronously
  (function(d){
     var js, id = \'facebook-jssdk\', ref = d.getElementsByTagName(\'script\')[0];
     if (d.getElementById(id)) {return;}
     js = d.createElement(\'script\'); js.id = id; js.async = true;
     js.src = "//connect.facebook.net/de_DE/all.js";
     ref.parentNode.insertBefore(js, ref);
   }(document));

  // Init the SDK upon load
  window.fbAsyncInit = function() {
    FB.init({
      appId      : \'433642263335655\', // App ID
      channelUrl : \'//\'+window.location.hostname+\'/channel\', // Path to your Channel File
      status     : true, // check login status
      cookie     : true, // enable cookies to allow the server to access the session
      xfbml      : true  // parse XFBML
    });

    // listen for and handle auth.statusChange events
    FB.Event.subscribe(\'auth.statusChange\', function(response) {
      if (response.authResponse) {
        // user has auth\'d your app and is logged into Facebook
        FB.api(\'/me\', function(me){
          if (me.name) {
            document.getElementById(\'auth-displayname\').innerHTML = me.name;
          }
        })
        document.getElementById(\'auth-loggedout\').style.display = \'none\';
        document.getElementById(\'auth-loggedin\').style.display = \'block\';
      } else {
        // user has not auth\'d your app, or is not logged into Facebook
        document.getElementById(\'auth-loggedout\').style.display = \'block\';
        document.getElementById(\'auth-loggedin\').style.display = \'none\';
      }
    });

    // respond to clicks on the login and logout links
    document.getElementById(\'auth-loginlink\').addEventListener(\'click\', function(){
      FB.login();
    });
    document.getElementById(\'auth-logoutlink\').addEventListener(\'click\', function(){
      FB.logout();
    }); 
  } 
</script>

<div id="auth-status">
    <div id="auth-loggedout">
      <a href="#" id="auth-loginlink">Login</a>
    </div>
    <div id="auth-loggedin" style="display:none">
      Hi, <span id="auth-displayname"></span>  
    (<a href="#" id="auth-logoutlink">logout</a>)
    </div>
</div>', ENT_QUOTES); ?>
</pre>

<h3>Ergebnis</h3>

<div id="fb-root"></div>
<script>
  // Load the SDK Asynchronously
  (function(d){
     var js, id = 'facebook-jssdk', ref = d.getElementsByTagName('script')[0];
     if (d.getElementById(id)) {return;}
     js = d.createElement('script'); js.id = id; js.async = true;
     js.src = "//connect.facebook.net/de_DE/all.js";
     ref.parentNode.insertBefore(js, ref);
   }(document));

  // Init the SDK upon load
  window.fbAsyncInit = function() {
    FB.init({
      appId      : '433642263335655', // App ID
      channelUrl : '//'+window.location.hostname+'/channel', // Path to your Channel File
      status     : true, // check login status
      cookie     : true, // enable cookies to allow the server to access the session
      xfbml      : true  // parse XFBML
    });

    // listen for and handle auth.statusChange events
    FB.Event.subscribe('auth.statusChange', function(response) {
      if (response.authResponse) {
        // user has auth'd your app and is logged into Facebook
        FB.api('/me', function(me){
          if (me.name) {
            document.getElementById('auth-displayname').innerHTML = me.name;
          }
        })
        document.getElementById('auth-loggedout').style.display = 'none';
        document.getElementById('auth-loggedin').style.display = 'block';
      } else {
        // user has not auth'd your app, or is not logged into Facebook
        document.getElementById('auth-loggedout').style.display = 'block';
        document.getElementById('auth-loggedin').style.display = 'none';
      }
    });

    // respond to clicks on the login and logout links
    document.getElementById('auth-loginlink').addEventListener('click', function(){
      FB.login();
    });
    document.getElementById('auth-logoutlink').addEventListener('click', function(){
      FB.logout();
    }); 
  } 
</script>

<div id="auth-status">
    <div id="auth-loggedout">
      <a href="#" id="auth-loginlink">Login</a>
    </div>
    <div id="auth-loggedin" style="display:none">
      Hi, <span id="auth-displayname"></span>  
    (<a href="#" id="auth-logoutlink">logout</a>)
    </div>
</div>

<h3>Optionen</h3>

<a href="https://developers.facebook.com/docs/authentication/" target="_blank">Core Concepts › Authentication</a>

<h3>Weiterführende Links</h3>

<a href="http://www.saaraan.com/2012/05/ajax-facebook-connect-with-jquery-php" target="_blank">Ajax Facebook Connect with jQuery &amp; PHP</a>

<h2>Serverseitig (PHP)</h2>

<h3>Code</h3>
<pre>
<?php echo htmlentities('<?php 

   $app_id = "433642263335655";
   $app_secret = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
   $my_url = "http://www.kickers-united.de/";

   #session_start();
   $code = $_REQUEST["code"];

   if(empty($code)) {
     $_SESSION[\'state\'] = md5(uniqid(rand(), TRUE)); //CSRF protection
     $dialog_url = "https://www.facebook.com/dialog/oauth?client_id=" 
       . $app_id . "&redirect_uri=" . urlencode($my_url) . "&state="
       . $_SESSION[\'state\']."&scope=email";

     echo("<script> top.location.href=\'" . $dialog_url . "\'</script>");
   }

   if($_SESSION[\'state\'] && ($_SESSION[\'state\'] === $_REQUEST[\'state\'])) {
     $token_url = "https://graph.facebook.com/oauth/access_token?"
       . "client_id=" . $app_id . "&redirect_uri=" . urlencode($my_url)
       . "&client_secret=" . $app_secret . "&code=" . $code;

     $response = file_get_contents($token_url);
     $params = null;
     parse_str($response, $params);

     $graph_url = "https://graph.facebook.com/me?access_token=" 
       . $params[\'access_token\'];

     $user = json_decode(file_get_contents($graph_url));
     echo("Hello " . $user->name);
   }
   else {
     echo("The state does not match. You may be a victim of CSRF.");
   }

 ?>', ENT_QUOTES); ?>
</pre>

<h3>Optionen</h3>

<a href="https://developers.facebook.com/docs/authentication/" target="_blank">Core Concepts › Authentication</a>