<h2>Selection</h2>
<p>
Standardmäßig werden die meisten Objekteigenschaften zurückgegeben, wenn man eine Abfrage macht. 
Man kann jedoch auch die Felder (oder Verbindungen) angeben, die dann zurückgegeben werden.
</p>

<p>
Zum Beispiel wird bei dieser URL nur die ID, Name und Profilbild von Ben ausgegeben:
</p>

<h3>Code</h3>
<p><a href="https://graph.facebook.com/bgolub?fields=id,name,picture&access_token=AAAAAAITEghMBACvjUWr3BjORxx2lbvrZB7ZCr5uH2t51yQ4R4NVdOPdNv9WH0g1ePfPhZBaWEjuV3xMUEAbrMAQlj2KYkdbF7KON2zPXLJFGxRue5Ar" target="_blank">https://graph.facebook.com/bgolub?fields=id,name,picture&amp;access_token=..</a></p>

<h3>Ergebnis</h3>
<pre>
<?php echo htmlentities('{
   "id": "15500414",
   "name": "Benjamin Golub",
   "picture": "https://fbcdn-profile-a.akamaihd.net/hprofile-ak-snc4/273766_15500414_753933865_q.jpg"
}', ENT_QUOTES); ?>
</pre>

<p>
Man kann ausserdem mehrere Objekte in einer Anfrage erhalten, indem man die "IDs" als Anfrage-Parameter setzt. 
Zum Beispiel erhält man bei der URL <a href="https://graph.facebook.com?ids=arjun,vernal">https://graph.facebook.com?ids=arjun,vernal</a> beide Profile in der selben Anfrage.
</p>

<h3>Code</h3>
<p><a href="https://graph.facebook.com/?ids=arjun,vernal&access_token=AAAAAAITEghMBAGhoJz4MjZBEYnSm4aWZAfHhgu8wniSvKTmXC5cKIMxwE25sOWwiKpbGdMLEPPbWZBxc2sjwB4sa4LjH28y2eERk0W6fF3PrSfhuyBl" target="_blank">https://graph.facebook.com/?ids=arjun,vernal&amp;access_token=...</a></p>

<h3>Ergebnis</h3>
<pre>
<?php echo htmlentities('{
   "arjun": {
      "id": "7901103",
      "name": "Arjun Banker",
      "first_name": "Arjun",
      "last_name": "Banker",
      "link": "https://www.facebook.com/Arjun",
      "username": "Arjun",
      "hometown": {
         "id": "109533479072558",
         "name": "Minnetonka, Minnesota"
      },
      "location": {
         "id": "114952118516947",
         "name": "San Francisco, California"
      },
      "bio": "tippity top",
      "work": [
         {
            "employer": {
               "id": "20531316728",
               "name": "Facebook"
            },
            "location": {
               "id": "104022926303756",
               "name": "Palo Alto, California"
            },
            "position": {
               "id": "109542932398298",
               "name": "Software Engineer"
            },
            "start_date": "2007-11",
            "end_date": "2011-11",
            "projects": [
               {
                  "id": "111177755627109",
                  "name": "Graph API",
                  "with": [
                     {
                        "id": "15500414",
                        "name": "Benjamin Golub"
                     }
                  ],
                  "description": "http://graph.facebook.com",
                  "start_date": "2009-10",
                  "end_date": "2009-10"
               },
               {
                  "id": "110991228979268",
                  "name": "Immediate Notifications",
                  "with": [
                     {
                        "id": "4842",
                        "name": "Sasha Rush"
                     }
                  ],
                  "description": "http://blog.facebook.com/blog.php?post=83313097130",
                  "start_date": "2009-03",
                  "end_date": "2009-04"
               },
               {
                  "id": "199369766756652",
                  "name": "Recruiting Tool",
                  "with": [
                     {
                        "id": "1221481",
                        "name": "Tracy Yang"
                     },
                     {
                        "id": "4811075",
                        "name": "Benjamin K. Billings"
                     },
                     {
                        "id": "200182",
                        "name": "Josh Pritchard"
                     }
                  ],
                  "description": "An internal applicant tracking system.",
                  "start_date": "2008-03",
                  "end_date": "2008-12"
               },
               {
                  "id": "190010597698689",
                  "name": "Data Reports & Dashboards",
                  "with": [
                     {
                        "id": "202875",
                        "name": "Ravi Grover"
                     }
                  ],
                  "start_date": "2007-11",
                  "end_date": "2008-03"
               },
               {
                  "id": "102426576504534",
                  "name": "Graph API, FQL for Profile",
                  "with": [
                     {
                        "id": "202875",
                        "name": "Ravi Grover"
                     }
                  ],
                  "from": {
                     "id": "202875",
                     "name": "Ravi Grover"
                  }
               },
               {
                  "id": "331631606868767",
                  "name": "Questions API",
                  "with": [
                     {
                        "id": "664195469",
                        "name": "Ralf Herbrich"
                     }
                  ],
                  "from": {
                     "id": "664195469",
                     "name": "Ralf Herbrich"
                  }
               }
            ]
         },
         {
            "employer": {
               "id": "113816405300191",
               "name": "Zillow"
            },
            "location": {
               "id": "110843418940484",
               "name": "Seattle, Washington"
            },
            "position": {
               "id": "148706268475836",
               "name": "Business Intelligence Analyst"
            },
            "with": [
               {
                  "id": "500587505",
                  "name": "Bill Nordwall"
               }
            ],
            "start_date": "2006-03",
            "end_date": "2007-10"
         },
         {
            "employer": {
               "id": "20528438720",
               "name": "Microsoft"
            },
            "location": {
               "id": "110843418940484",
               "name": "Seattle, Washington"
            },
            "position": {
               "id": "124875857558336",
               "name": "SDET"
            },
            "with": [
               {
                  "id": "7913511",
                  "name": "Stephen Sisk"
               }
            ],
            "start_date": "2004-08",
            "end_date": "2006-03",
            "projects": [
               {
                  "id": "201056906571251",
                  "name": "Windows Workflow Foundation",
                  "with": [
                     {
                        "id": "671738553",
                        "name": "Lance Lindberg"
                     },
                     {
                        "id": "1181029459",
                        "name": "Vijay Subramani"
                     },
                     {
                        "id": "1337734089",
                        "name": "Krishna Sunkammurali"
                     },
                     {
                        "id": "500622793",
                        "name": "Anandhi Somasekaran"
                     },
                     {
                        "id": "741573203",
                        "name": "Akash Sagar"
                     },
                     {
                        "id": "572141027",
                        "name": "Mohamed Ibrahim"
                     },
                     {
                        "id": "500637259",
                        "name": "Marcelo Uemura"
                     },
                     {
                        "id": "2043535",
                        "name": "Angel Azcarraga"
                     },
                     {
                        "id": "2719481",
                        "name": "Nathan Talbert"
                     }
                  ],
                  "start_date": "2004-08",
                  "end_date": "2006-03"
               }
            ]
         },
         {
            "employer": {
               "id": "7706457055",
               "name": "Dell"
            },
            "location": {
               "id": "106224666074625",
               "name": "Austin, Texas"
            },
            "position": {
               "id": "115865898427443",
               "name": "Programmer Analyst"
            },
            "with": [
               {
                  "id": "7956356",
                  "name": "Lilly Chau"
               }
            ],
            "start_date": "2003-06",
            "end_date": "2004-07"
         },
         {
            "employer": {
               "id": "268024569901198",
               "name": "Retek"
            },
            "position": {
               "id": "182348451795425",
               "name": "Web Engineer Intern"
            },
            "start_date": "2000-07",
            "end_date": "2000-08"
         }
      ],
      "sports": [
         {
            "id": "102173226491776",
            "name": "Soccer"
         },
         {
            "id": "114371035246890",
            "name": "Ping Pong",
            "with": [
               {
                  "id": "1206763",
                  "name": "Sachin Banker"
               },
               {
                  "id": "3404106",
                  "name": "Atish Mehta"
               },
               {
                  "id": "1066260003",
                  "name": "Rishin Banker"
               },
               {
                  "id": "1429725010",
                  "name": "Mohin Banker"
               }
            ]
         }
      ],
      "favorite_teams": [
         {
            "id": "147054831936",
            "name": "A.C. Milan"
         }
      ],
      "favorite_athletes": [
         {
            "id": "22193768400",
            "name": "Kristi Yamaguchi"
         },
         {
            "id": "79979913992",
            "name": "Dwyane Wade"
         },
         {
            "id": "120900281258531",
            "name": "Sachin Tendulkar"
         }
      ],
      "inspirational_people": [
         {
            "id": "106272096071533",
            "name": "Richard Feynman"
         }
      ],
      "education": [
         {
            "school": {
               "id": "107922345906866",
               "name": "Texas Academy Of Math And Science"
            },
            "year": {
               "id": "132393000129123",
               "name": "2001"
            },
            "type": "High School",
            "classes": [
               {
                  "id": "188852561145834",
                  "name": "Linear Algebra",
                  "with": [
                     {
                        "id": "1211703",
                        "name": "Hari Palaiyanur"
                     }
                  ]
               }
            ]
         },
         {
            "school": {
               "id": "109578709061172",
               "name": "McKinney High School"
            },
            "year": {
               "id": "144503378895008",
               "name": "1999"
            },
            "type": "High School"
         },
         {
            "school": {
               "id": "245640871929",
               "name": "The University of Texas at Austin"
            },
            "year": {
               "id": "194603703904595",
               "name": "2003"
            },
            "concentration": [
               {
                  "id": "104076956295773",
                  "name": "Computer Science"
               }
            ],
            "type": "College"
         }
      ],
      "gender": "male",
      "interested_in": [
         "female"
      ],
      "religion": "Spiritual",
      "political": "Liberal",
      "locale": "en_US",
      "languages": [
         {
            "id": "106059522759137",
            "name": "English"
         }
      ],
      "updated_time": "2012-06-23T18:36:02+0000"
   },
   "vernal": {
      "id": "9074",
      "name": "Mike Vernal",
      "first_name": "Mike",
      "last_name": "Vernal",
      "link": "https://www.facebook.com/vernal",
      "username": "vernal",
      "bio": "The best advice I\'ve heard recently is to try to \"hack the world.\"  It\'s pretty good advice, if you think about it.\r\n\r\nWhen I was 11, I won a trip for me and my family to Legoland in Denmark.  There was a huge Lego village in the Toys \'R Us in Herald Square in NYC.  There was a contest to guess how many lego blocks there were in the entire village.  I got within seven.",
      "quotes": "\"The best way to predict the future is to invent it.\" - Alan Kay",
      "work": [
         {
            "employer": {
               "id": "20531316728",
               "name": "Facebook"
            },
            "location": {
               "id": "104022926303756",
               "name": "Palo Alto, California"
            },
            "position": {
               "id": "107629839267064",
               "name": "Engineer"
            },
            "description": "Platform",
            "start_date": "2008-01",
            "end_date": "0000-00",
            "projects": [
               {
                  "id": "153823678006564",
                  "name": "Open Graph",
                  "with": [
                     {
                        "id": "4",
                        "name": "Mark Zuckerberg"
                     }
                  ],
                  "from": {
                     "id": "4",
                     "name": "Mark Zuckerberg"
                  }
               },
               {
                  "id": "188620931172867",
                  "name": "Social Plugins",
                  "with": [
                     {
                        "id": "556177531",
                        "name": "Yohann Richard"
                     }
                  ],
                  "from": {
                     "id": "556177531",
                     "name": "Yohann Richard"
                  }
               },
               {
                  "id": "170672292946231",
                  "name": "Facebook Platform",
                  "with": [
                     {
                        "id": "507763995",
                        "name": "Vladimir Fedorov"
                     },
                     {
                        "id": "5943",
                        "name": "Carl Sjogreen"
                     }
                  ],
                  "from": {
                     "id": "5943",
                     "name": "Carl Sjogreen"
                  }
               },
               {
                  "id": "286859671342103",
                  "name": "FB Platform for Mobile",
                  "with": [
                     {
                        "id": "11674",
                        "name": "Jonathan Matus"
                     }
                  ],
                  "from": {
                     "id": "11674",
                     "name": "Jonathan Matus"
                  }
               },
               {
                  "id": "306032156132292",
                  "name": "Social Discovery for Mobile Platform",
                  "with": [
                     {
                        "id": "2901279",
                        "name": "Luke Shepard"
                     }
                  ],
                  "from": {
                     "id": "2901279",
                     "name": "Luke Shepard"
                  }
               },
               {
                  "id": "113920498683469",
                  "name": "Facebook Connect",
                  "with": [
                     {
                        "id": "2901279",
                        "name": "Luke Shepard"
                     }
                  ],
                  "from": {
                     "id": "2901279",
                     "name": "Luke Shepard"
                  }
               }
            ]
         },
         {
            "employer": {
               "id": "20528438720",
               "name": "Microsoft"
            },
            "location": {
               "id": "109738839051539",
               "name": "Redmond, Washington"
            },
            "position": {
               "id": "107629839267064",
               "name": "Engineer"
            },
            "description": "Storage + synchronization for Live Mesh.",
            "start_date": "2006-05",
            "end_date": "2008-01",
            "projects": [
               {
                  "id": "154877834565390",
                  "name": "Live Mesh",
                  "with": [
                     {
                        "id": "672120844",
                        "name": "Mike Zintel"
                     },
                     {
                        "id": "1945479",
                        "name": "Ray Ozzie"
                     },
                     {
                        "id": "1112161",
                        "name": "David Treadwell"
                     },
                     {
                        "id": "711562108",
                        "name": "Wei Zhu"
                     },
                     {
                        "id": "10711479",
                        "name": "Aakash Kambuj"
                     },
                     {
                        "id": "202726",
                        "name": "Alex Himel"
                     },
                     {
                        "id": "507763995",
                        "name": "Vladimir Fedorov"
                     }
                  ],
                  "start_date": "2006-05",
                  "end_date": "2008-01"
               }
            ]
         },
         {
            "employer": {
               "id": "20528438720",
               "name": "Microsoft"
            },
            "location": {
               "id": "109738839051539",
               "name": "Redmond, Washington"
            },
            "position": {
               "id": "115600405159036",
               "name": "PM"
            },
            "description": "Programming model and infrastructure for Windows Communication Foundation (i.e., Indigo).",
            "start_date": "2002-06",
            "end_date": "2006-05"
         },
         {
            "employer": {
               "id": "119663778045425",
               "name": "Microsoft"
            },
            "from": {
               "id": "678628143",
               "name": "Paresh Suthar"
            },
            "projects": [
               {
                  "id": "154877834565390",
                  "name": "Live Mesh",
                  "with": [
                     {
                        "id": "678628143",
                        "name": "Paresh Suthar"
                     }
                  ],
                  "from": {
                     "id": "678628143",
                     "name": "Paresh Suthar"
                  }
               }
            ]
         }
      ],
      "education": [
         {
            "school": {
               "id": "102733033106553",
               "name": "Harrison High School, Harrison, New York"
            },
            "type": "High School"
         },
         {
            "school": {
               "id": "105930651606",
               "name": "Harvard University"
            },
            "year": {
               "id": "194878617211512",
               "name": "2002"
            },
            "concentration": [
               {
                  "id": "104076956295773",
                  "name": "Computer Science"
               }
            ],
            "type": "College"
         }
      ],
      "gender": "male",
      "website": "http://www.facebook.com/",
      "locale": "en_US",
      "updated_time": "2012-06-14T17:17:01+0000"
   }
}', ENT_QUOTES); ?>
</pre>

<h3>Optionen</h3>

<a href="https://developers.facebook.com/docs/reference/api/" target="_blank">Core Concepts › Graph API</a>