<h2>Authorization</h2>
<p>
Die Graph API als solche ermöglicht den einfachen Zugriff auf 
alle öffentlichen Informationen über ein Objekt. Zum Beispiel 
gibt https://graph.facebook.com/btaylor (Bret Taylor) alle 
öffentlichen Informationen über Bret - wie Vorname, Name und Profilbild. 

Um zusätzliche Informationen über einen Benutzer zu bekommen, 
muss man zunächst seine Erlaubnis bekommen.
 
Für erweiterte Anfragen braucht man einen Access Token des Benutzers. 
Nachdem man diesen Access Token erhalten hat, 
kann man autorisierte Zugriffe im Namen des Benutzers ausführen.
</p>

<h3>Code</h3>
<p><a href="https://graph.facebook.com/btaylor" target="_blank">https://graph.facebook.com/btaylor</a></p>

<h3>Ergebnis</h3>
<pre>
<?php echo htmlentities('{
   "id": "220439",
   "name": "Bret Taylor",
   "first_name": "Bret",
   "last_name": "Taylor",
   "link": "https://www.facebook.com/btaylor",
   "username": "btaylor",
   "gender": "male",
   "locale": "en_US"
}', ENT_QUOTES); ?>
</pre>

<p>
Mit einem Access Token für einen Benutzer ohne erweiterte Freigabeeinstellungen kann man Informationen zugreifen, die der Benutzer nicht für jeden zur Verfügung gestellt hat. 
Wenn man spezifische Informationen über einen Benutzer benötigt, wie die E-Mail-Adresse oder den beruflichen Werdegang, muss man um die spezifischen erweiterten Berechtigungen bitten.
</p>

<h3>Code</h3>
<p><a href="https://graph.facebook.com/btaylor?access_token=AAAAAAITEghMBACvjUWr3BjORxx2lbvrZB7ZCr5uH2t51yQ4R4NVdOPdNv9WH0g1ePfPhZBaWEjuV3xMUEAbrMAQlj2KYkdbF7KON2zPXLJFGxRue5Ar" target="_blank">https://graph.facebook.com/btaylor?access_token=...</a></p>

<h3>Ergebnis</h3>
<pre>
<?php echo htmlentities('{
   "id": "220439",
   "name": "Bret Taylor",
   "first_name": "Bret",
   "last_name": "Taylor",
   "link": "https://www.facebook.com/btaylor",
   "username": "btaylor",
   "hometown": {
      "id": "108363292521622",
      "name": "Oakland, California"
   },
   "location": {
      "id": "109650795719651",
      "name": "Los Gatos, California"
   },
   "work": [
      {
         "employer": {
            "id": "20531316728",
            "name": "Facebook"
         },
         "position": {
            "id": "106275566077710",
            "name": "Chief Technology Officer"
         },
         "start_date": "2009-08",
         "projects": [
            {
               "id": "153823678006564",
               "name": "Open Graph",
               "with": [
                  {
                     "id": "4",
                     "name": "Mark Zuckerberg"
                  }
               ],
               "from": {
                  "id": "4",
                  "name": "Mark Zuckerberg"
               }
            }
         ]
      },
      {
         "employer": {
            "id": "99073561945",
            "name": "FriendFeed"
         },
         "location": {
            "id": "108212625870265",
            "name": "Mountain View, California"
         },
         "position": {
            "id": "130899310279007",
            "name": "Founder, CEO"
         },
         "start_date": "2007-10",
         "end_date": "2009-08"
      },
      {
         "employer": {
            "id": "86860316161",
            "name": "Benchmark Capital"
         },
         "location": {
            "id": "104048449631599",
            "name": "Menlo Park, California"
         },
         "position": {
            "id": "104098916294662",
            "name": "Entrepreneur In Residence"
         },
         "start_date": "2007-06",
         "end_date": "2007-09"
      },
      {
         "employer": {
            "id": "104958162837",
            "name": "Google"
         },
         "location": {
            "id": "108212625870265",
            "name": "Mountain View, California"
         },
         "position": {
            "id": "103146903077097",
            "name": "Group Product Manager"
         },
         "start_date": "2003-03",
         "end_date": "2007-06",
         "projects": [
            {
               "id": "162849873739882",
               "name": "Google Maps",
               "with": [
                  {
                     "id": "207830",
                     "name": "Jim Norris"
                  },
                  {
                     "id": "767560056",
                     "name": "Lars Eilstrup Rasmussen"
                  },
                  {
                     "id": "734236612",
                     "name": "Jens E. Rasmussen"
                  }
               ]
            }
         ]
      }
   ],
   "favorite_teams": [
      {
         "id": "112437965439134",
         "name": "Stanford Cardinal"
      },
      {
         "id": "112852666874",
         "name": "San Francisco 49ers"
      },
      {
         "id": "109892325707088",
         "name": "A\'s"
      }
   ],
   "favorite_athletes": [
      {
         "id": "106056612759445",
         "name": "Toby Gerhart"
      },
      {
         "id": "112417838771364",
         "name": "Joe Montana"
      },
      {
         "id": "374111189271559",
         "name": "Andrew Luck"
      }
   ],
   "inspirational_people": [
      {
         "id": "103864656318694",
         "name": "Linus Torvalds"
      },
      {
         "id": "113529011990795",
         "name": "Steve Jobs"
      }
   ],
   "education": [
      {
         "school": {
            "id": "112075895485567",
            "name": "Acalanes High"
         },
         "year": {
            "id": "144560162276732",
            "name": "1998"
         },
         "type": "High School"
      },
      {
         "school": {
            "id": "6192688417",
            "name": "Stanford University"
         },
         "year": {
            "id": "194878617211512",
            "name": "2002"
         },
         "concentration": [
            {
               "id": "104076956295773",
               "name": "Computer Science"
            }
         ],
         "type": "College"
      },
      {
         "school": {
            "id": "6192688417",
            "name": "Stanford University"
         },
         "degree": {
            "id": "193640483997198",
            "name": "MS"
         },
         "year": {
            "id": "194603703904595",
            "name": "2003"
         },
         "concentration": [
            {
               "id": "104076956295773",
               "name": "Computer Science"
            }
         ],
         "type": "Graduate School"
      }
   ],
   "gender": "male",
   "locale": "en_US",
   "languages": [
      {
         "id": "106059522759137",
         "name": "English"
      },
      {
         "id": "110343528993409",
         "name": "Spanish"
      }
   ],
   "updated_time": "2012-06-19T07:26:23+0000"
}', ENT_QUOTES); ?>
</pre>

<h3>Optionen</h3>

<a href="https://developers.facebook.com/docs/reference/api/" target="_blank">Core Concepts › Graph API</a>