
/*
 
 |||||||      |             |||||||
 |af||||            ||      |||| ||
  
 
 PRESS    1 -> normal
          2 -> hard trail
          3 -> trail based on brightness
          4 -> reversed trail based on brightness
          3 -> pseudo BackgroundSubtraction
          5 -> cannyEdges (OpenCv)
          
          
          r -> random color distribution
          
          0 -> Reset
          
          UP -> trail +
          DOWN -> trail -
          RIGHT -> adjust color + 
          LEFT -> adjust color -
     
*/


import processing.video.*;
import gab.opencv.*;

Movie cam;
OpenCV opencv;
PFont myFont;
PShader clr;
PGraphics pg;

///////////////////////////////
/// LOCATION OF YOUR INPUT FILE  
String mLoc = "E:/vids/MVI_5018.MOV";
///////////////////////////////

String       hm = "", sm = "", am = "", ram = "", cm = "",space = "     |     " ;

//
int div = 135,
    cnt;
//
float mode = 1,
      trail = 0.05,
      speed = 3,
      r1=1,r2=1,r3=1;
//
boolean init =true,
        sub = false,
        canny = false;


void setup() {
  
  cam = new Movie(this, mLoc);

  cam.loop();
  cam.jump(random(cam.duration()));
  cam.speed(speed);
  cam.volume(0);

  opencv = new OpenCV(this, cam);
   
  size(cam.width, cam.height, P2D); 
  pg = createGraphics(width, height, P2D);
  myFont = createFont("Arial", 15, true);
  clr = loadShader("clr.glsl");
  
}

void draw() {
  
/// to shader
  clr.set("in_clr", div/255.0);
  clr.set("trail", 1.0-trail);
  clr.set("m", mode);
  clr.set("sub", sub==false? 0.0: 1.0);
  clr.set("r1", r1);
  clr.set("r2", r2);
  clr.set("r3", r3);


/// load up opencv for further tweaking
  opencv.loadImage(cam);
  
/// findcannyedges
  if(canny){
    clr.set("in_clr", 1.0);
    opencv.gray();
    opencv.findCannyEdges(20,80);
  }else{
    opencv.useColor();
  }
  
/// pgraphics unit
  pg.beginDraw();
  pg.image(opencv.getOutput(), 0, 0, width, height);
  pg.shader(clr);
  pg.endDraw();
  image(pg, 0, 0);
  
/// catch some frames at the beginning
  if (init) {
    clr.set("trail", 1.0);
    cnt++;
    if (cnt>5) {
      init = false;
    }
  } 
  
/// infos
  fill(255);
  rect(0, 0, width, 20);
  fill(0, 255);
  textFont(myFont, 15);
  hm = mode>1 && mode<3? space+ "hard trail" : ""; 
  sm = sub&& mode>1? space+ "pseudo bgs" : ""; 
  cm = canny? space + "cannyEdges" : "";
  am = mode>2 && mode<4? space + "alphatrail" : "";
  ram = mode>3? space + "reversed alphatrail" : "";
  text("color_ratio:  " + nf(div/255., 1, 3) + space + "trail_ratio: " + nf(trail, 1, 3) + hm + sm + am + ram + cm , 15, 15);
  
/// recording
  rec();
  
}

/// get cam image
void movieEvent(Movie m) {
  if (m.available()) {  
    m.read();
  }
}

/// buttons
void keyPressed() {
  if (key == CODED) {
    if (keyCode == UP) {
      if (trail<0.95)trail+=0.05;
    } else if (keyCode == DOWN) {
      if (trail>=0.05) trail-=0.05;
    } else if (keyCode == LEFT) {
      if (div>20) div--;
    } else if (keyCode == RIGHT) {
      if (div<160) div++;
    }
  } else {
    if (key == '1') {
      mode = 1;
      sub = false;
    } else if (key == '2') {
      mode = 2;
    } else if (key == '3') {
      mode = 3; 
    }else if (key == '4') {
      mode = 4; 
    } else if (key == '5') {
      sub = !sub;
    }else if (key == '6') {
      canny = !canny;    
    }else if (key == 'r') {
      r1=random(0.7,1);
      r2=random(0.85,1);
      r3=random(0.9,1);
    } else if (key == '0') {
      div = 135;
      sub = false;
      canny = false;
      mode = 1;
      trail = 0.1;
      r1=1;r2=1;r3=1;
    }    
  }
}


///rec
void rec(){

    //saveFrame("drops-######.tga");
 
}

