#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform sampler2D texture;
uniform float in_clr;
uniform float trail;
uniform float m;
uniform float sub;
uniform float r1;
uniform float r2;
uniform float r3;

varying vec4 vertColor;
varying vec4 vertTexCoord;


void main() {
	
    vec4 col = texture2D(texture, vertTexCoord.st);
	///"half" negative
	float r = abs(in_clr*r1-col.r);
	float g = abs(in_clr*r2-col.g);
	float b = abs(in_clr*r3-col.b);
	
	///pseudo brightness (no lum)
	float chk = r+g+b/3.0;
	if(m < 2){
		//default
		gl_FragColor = vec4(r,g,b,trail);
	}else if(m<3 && m > 1){
		//ping-ponged
		float chk = r+g+b/3.0;
		if(chk>0.5){
			gl_FragColor = vec4(r,g,b,chk);
		}else {
			if(sub>0){
			gl_FragColor = vec4(0,0,0,1);
			}else{
			gl_FragColor = vec4(0,0,0,0);
			}	
		}
	}else if(m<4 && m > 2){
		//alpha=brightness
		gl_FragColor = vec4(r,g,b,pow(chk,1.0+chk));
	}else if(m<5 && m > 3){
		//alpha=brightness
		gl_FragColor = vec4(r,g,b,1-chk);
	}
  
}