import processing.opengl.*;
import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.texture.*; 
import oscP5.*;
import ddf.minim.*;

// let's set a filter (which returns true if file's extension is .jpg)
java.io.FilenameFilter worldFilter = new java.io.FilenameFilter() {
  boolean accept(File dir, String name) {
    return !name.toLowerCase().contains(".");
  }
};

// should be a multiple of 4:3
int boxCountX = 8;
int boxCountY = 6;

Texture tex;
Texture error;
OscP5 oscP5;
float top, bottom, left, right;

// sound
Minim minim;
AudioPlayer levelSound;
AudioPlayer gameOverSound;
AudioPlayer finishSound;
AudioPlayer menuSound;

// opengl parameter
GL  gl;
GLU glu;
float aspect, camZ;

int defaultBox;
int firstBox;
int avatar;
int avatar_footprint;

float scaleFactor = 100;
int walkZ = 0;

float xWorldTrans, yWorldTrans;
float threshold = 0.1;

int renderBegin = 0;
int renderEnd = 80;

int camShiftX = 0;

// info font
PFont font;

int quadLength = 100;

// file io
String[] worldLines;
String[] highscoreLines;
String[] infoLines;

// world.txt is build like this:
// 0,0,0 1,3,2 0,4,1
// these are 3 tiles with different options
// object,count,shift

// world array
int[][][] world;
int selectedWorld = 0;
String[] worlds;

ArrayList<HighscoreEntry> highscore;

String[] highscoreName = {"A", "_", "_"};

int charASCII = 65;
int charPos = 0;

boolean countdown = true;
int countdownSteps = 0;

boolean DEBUG = false; // automatic walking and game over deactivated

// gui
boolean render = false;
String[] menu = { 
  "START", "WORLD", "HIGHSCORE", "QUIT"
};
int highlightMenu = 0;
int gameState = 0; // 0=menu, 1=in game, 2=game over, 3=highscore, 4=finished
int menuState = 0; // 0=main menu, 1 = world menu, 2=type in name

PrintWriter output;
float[] avatarColor = new float[3];

PImage header;
PImage headerHighscore;

void setup()
{
  size(1024, 768, OPENGL);

  //frame.setLocation(screen.width,0); // beamer
  frame.setLocation(100,100); // debug

  hint(DISABLE_OPENGL_2X_SMOOTH);
  hint(DISABLE_OPENGL_ERROR_REPORT);
  aspect = (float)width / (float)height;
  camZ = ((height / 2.0) / tan(PI * 60.0 / 360.0));
  colorMode(RGB, 1);

  frameRate(30);
  
  header = loadImage("images/CubeCityHeader1000.gif");
  headerHighscore = loadImage("images/CubeCityHeader_HighScore.gif");

  initGL();

  minim = new Minim(this);
//  levelSound = minim.loadFile("CubeFighterSound.mp3");
  gameOverSound = minim.loadFile("sounds/GameOverLETSGETLOUD.mp3");
  finishSound = minim.loadFile("sounds/Championata.mp3");
  menuSound = minim.loadFile("sounds/Menu1.mp3");

  font = loadFont("fonts/Adore64-48.vlw");
  textFont(font, 48);

  xWorldTrans = boxCountX/2;

  oscP5 = new OscP5(this, 7000);

  java.io.File folder = new java.io.File(dataPath("")+"worlds"); // we'll have a look in the data folder
  worlds = folder.list(worldFilter); // list the files in the data folder, passing the filter as parameter
  println(worlds.length + " world(s)."); // get and display the number of world files

  // display the filenames
  for (int i = 0; i < worlds.length; i++) {
    println(worlds[i]);
  }

  loadWorldData();
  loadWorldInfo();
  
  menuSound.loop();
}

public void init()
{
  frame.removeNotify();
  frame.setUndecorated(true);
  frame.addNotify();
  super.init();
}

void draw()
{
  if (render)
  {
    background(0);

    if (!DEBUG && gameState == 1)
    {
      if (!countdown)
      {
        walkZ++;
      }
    }

    gl.glPushMatrix();

    // berechnung der verschiebung in x achse
    camShiftX = (int)(((((1-right)-0.5)*2 + ((1-left)-0.5)*2) * 0.5) * 160);

    callGL();

    float shiftX = 0;
    float shiftZ = 0;

    gl.glScalef(scaleFactor, scaleFactor, scaleFactor);
    gl.glTranslatef(-xWorldTrans, -3, walkZ * 0.1);

    left = 0.4;
    right = 0.6;
    top = 0.6;
    bottom = 0.0001;

    float x = (1 - right) * boxCountX;
    float y = bottom * boxCountY;
    float w = ((1 - left) - (1 - right)) * boxCountX;
    float h = (top - bottom) * boxCountY;

    gl.glColor3f(avatarColor[0], avatarColor[1], avatarColor[2]);

    // draw avatar
    gl.glPushMatrix();
    gl.glTranslatef(x, y, (-walkZ + 10) * 0.1);
    gl.glScalef(w, h, 1);
    gl.glCallList(avatar);
    gl.glPopMatrix();
    // draw avatar footprint
    gl.glPushMatrix();
    gl.glTranslatef(x, 0.001, (-walkZ + 10) * 0.1);
    gl.glScalef(w, 1, 1);
    gl.glCallList(avatar_footprint);
    gl.glPopMatrix();

//    if (walkZ % 10 == 0 && walkZ > 0 && walkZ < world.length * 10 && gameState == 1)
//    {
//      int end = min((boxCountX - 1), floor(x + threshold));
//      int start = max(0, floor((x + w) - threshold));
//
//      for (int i = end; i <= start; i++)
//      {
//        int pos = (int)(walkZ * 0.1);
//        // check if there is an object in range
//        if (world[pos][i][0] > 0)
//        {
//          // check if the player hits the object
//          float boxX = i;  
//          float boxY = world[pos][i][2];
//          float boxWidth = 1;
//          float boxHeight = world[pos][i][1];
//
//          if (rectangle_collision(x, y, w, h, boxX, boxY, boxWidth, boxHeight) && !DEBUG)
//          {
//            gameState = 2; // game over
//            levelSound.pause();
//            gameOverSound.play();
//          }
//        }
//      }
//    }

    renderBegin = max(0, floor(walkZ * 0.1) - 3);
    renderEnd = min(renderBegin+80, world.length);

    gl.glTranslatef(0, 0, -renderBegin);
    // draw world
    
    //println("rednerBegin: " + renderBegin);
    
    tex.bind();
    tex.enable();
    for (int i = renderBegin; i != renderEnd; i++)
    {
      gl.glPushMatrix();
      // bottom
      if (i > renderBegin + 1)
      {
        int pos = (int)(walkZ * 0.1);
        
        if (pos == i && walkZ % 10 == 0 && walkZ > 0 && walkZ < world.length * 10)
        {
          
          //println(pos + " " + walkZ + " " + i);
          
          for (int j = 0; j != world[i].length; j++)
          {
            
            // check if there is an object in range
            if (world[pos][j][0] > 0)
            {
              //println("check collision...");
              
              // check if the player hits the object
              float boxX = j;  
              float boxY = world[i][j][2];
              float boxWidth = 1;
              float boxHeight = world[i][j][1];
              
              //println("boxX: " + boxX + " boxY: " + boxY + " boxWidth: " + boxWidth + " boxHeight: " + boxHeight);
    
              boolean collision = false;
              if (rectangle_collision(x, y, w, h, boxX, boxY, boxWidth, boxHeight) && !DEBUG)
              {
                //println("Collision.");
                if (gameState == 1)
                {
                  gameState = 2; // game over
                  levelSound.pause();
                  gameOverSound.play();
                }
                collision = true;
              }
              
              if (collision)
              {
                tex.disable();
                error.bind();
                error.enable();
              }
              
              if (world[i][j][2] > 0)
              {
                gl.glCallList(defaultBox);
              } 
              gl.glPushMatrix();
              gl.glTranslatef(0, world[i][j][2], 0);
              for (int c = 0; c != world[i][j][1]; c++)
              {
                gl.glCallList(world[i][j][0] + 1);
                gl.glTranslatef(0, 1, 0);
              }
              gl.glPopMatrix();
              
              if (collision)
              {
                error.disable();
                tex.bind();
                tex.enable();
                collision = false;
              }
            }
            else
            {
              gl.glCallList(defaultBox);
            }
            gl.glTranslatef(1, 0, 0);
          }
        }
        else
        {
          for (int j = 0; j != world[i].length; j++)
          {
            if (world[i][j][2] > 0)
            {
              gl.glCallList(defaultBox);
            } 
            gl.glPushMatrix();
            gl.glTranslatef(0, world[i][j][2], 0);
            for (int c = 0; c != world[i][j][1]; c++)
            {
              gl.glCallList(world[i][j][0] + 1);
              gl.glTranslatef(0, 1, 0);
            }
            gl.glPopMatrix();
            gl.glTranslatef(1, 0, 0);
          }
        }
      }
      else
      {
        for (int j = 0; j != world[i].length; j++)
        {
          gl.glCallList(defaultBox);
          gl.glTranslatef(1, 0, 0);
        }
      }
      gl.glPopMatrix();

      // left
      gl.glPushMatrix();
      gl.glRotatef(-90, 0, 0, -1);
      for (int j = 0; j != boxCountY; j++)
      {
        gl.glCallList(defaultBox);
        gl.glTranslatef(1, 0, 0); // translate x, because of rotation
      }
      gl.glPopMatrix();

      // right
      gl.glPushMatrix();
      gl.glRotatef(-90, 0, 0, -1);
      gl.glTranslatef(0, -boxCountX, 0);
      for (int j = 0; j != boxCountY; j++)
      {
        gl.glCallList(defaultBox);
        gl.glTranslatef(1, 0, 0); // translate x, because of rotation
      }
      gl.glPopMatrix();

      // top
      gl.glPushMatrix();
      gl.glRotatef(-180, 0, 0, -1);
      gl.glTranslatef(-boxCountX, -boxCountY, 0);
      for (int j = 0; j != boxCountX; j++)
      {
        gl.glCallList(defaultBox);
        gl.glTranslatef(1, 0, 0); // translate x, because of rotation
      }
      gl.glPopMatrix();

      gl.glTranslatef(0, 0, -1);
    }
    
    if (walkZ > world.length * 10 && gameState == 1)
    {
      gameState = 4;
      levelSound.pause();
      finishSound.play();
    }
    
    tex.disable();
    gl.glPopMatrix();
    
    if (countdown)
    {
      // reset opengl camera settings
      perspective();
    
      countdownSteps++;
      text((3 - floor(countdownSteps/30)), 490, 400);
      if (countdownSteps > 88)
      {
        countdown = false;
        levelSound.loop();
        countdownSteps = 0;
      }
    }
  }
  
  // reset opengl camera settings
  perspective();

  text(walkZ, 30, 80);

  if (gameState != 1)
  {
    switch(gameState)
    {
    case 0:  // menu screen
      background(0);
      
      image(header, 12, 12);

      int y = 408;
      for (int i = 0; i != menu.length; i++)
      {
        if (i == highlightMenu)
        {
          fill(0,255,0);
          if (menuState == 1)
          {
            fill(255,0,200);
          }
        }
        else
        {
          fill(255,255,255);
        }
        text(menu[i], 132, y);

        if (i == 1) // world
        {          
          if (selectedWorld > 0)
          {
            text("<", 386, y);
          }
          if (selectedWorld < (worlds.length - 1))
          {
            text(">", 476 + (worlds[selectedWorld].length() * 42 + (worlds[selectedWorld].length() - 1) * 6), y);
          }
          text(worlds[selectedWorld], 452, y);
        }

        y += 80;
      }
      break;
    case 2: // game over
      //background(0);
      fill(255,255,255);
      text("GAME OVER", 260, 400);
      text(join(highscoreName, ""), 420, 500);
      //walkZ = 0;
      //renderBegin = 0;
      menuState = 2;
      break;
    case 3: // highscore entry
      background(0);
      image(headerHighscore, 12, 12);
      
      int yTmp = 400;
       
      for (int i = 0; i != highscore.size(); i++)
      {
        text((i+1) + " " + highscore.get(i).getName() + " " + highscore.get(i).getScore(), 100, yTmp + 50*(i));
      }
      break;
    case 4: // finished
      //background(0);
      fill(255,255,255);
      text("CHAMPION!!!", 260, 400);
      text(join(highscoreName, ""), 420, 500);
      //walkZ = 0;
      //renderBegin = 0;
      menuState = 2;
      break;
    }
  }
}

void callGL()
{
  gl.glMatrixMode(GL.GL_PROJECTION);
  gl.glLoadIdentity();
  glu.gluPerspective(180/3.0, aspect, camZ/100.0, camZ*10.0);
  glu.gluLookAt(camShiftX, 0, camZ, camShiftX, 0, 0, 0, 1, 0);
  gl.glMatrixMode(GL.GL_MODELVIEW);
  gl.glLoadIdentity();
}

void initGL()
{
  glu = new GLU();
  gl = ((PGraphicsOpenGL)g).gl;

  defaultBox = gl.glGenLists(3);

  gl.glNewList(defaultBox, GL.GL_COMPILE);

  //tex.bind(); 
  //tex.enable();
  gl.glColor3f(1, 1, 1);
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(0, 1, 0);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 0, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 0, -1);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 0, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 0, 0);
  gl.glEnd();
  //tex.disable();

  gl.glEndList();

  firstBox = defaultBox + 1;

  gl.glNewList(firstBox, GL.GL_COMPILE);

  //tex.bind(); 
  //tex.enable();

  //gl.glColor3f(1, 1, 1);

  // bottom
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(0, -1, 0);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 0, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 0, -1);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 0, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 0, 0);
  gl.glEnd();

  // front
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(0, 0, 1);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 0, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 1, 0);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 1, 0);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 0, 0);
  gl.glEnd();

  // top
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(0, 1, 0);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 1, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 1, -1);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 1, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 1, 0);
  gl.glEnd();

  // back
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(0, 0, -1);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 0, -1);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 1, -1);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 1, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 0, -1);
  gl.glEnd();

  // left
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(-1, 0, 0);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(0, 0, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(0, 1, 0);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(0, 1, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(0, 0, -1);
  gl.glEnd();

  // right
  gl.glBegin(GL.GL_QUADS);
  gl.glNormal3f(1, 0, 0);
  gl.glTexCoord2f(0, 0); 
  gl.glVertex3f(1, 0, 0);
  gl.glTexCoord2f(0, 1); 
  gl.glVertex3f(1, 1, 0);
  gl.glTexCoord2f(1, 1); 
  gl.glVertex3f(1, 1, -1);
  gl.glTexCoord2f(1, 0); 
  gl.glVertex3f(1, 0, -1);
  gl.glEnd();

  //tex.disable();

  gl.glEndList();

  avatar = firstBox + 1;

  gl.glNewList(avatar, GL.GL_COMPILE);

  //gl.glColor3f(0, 1.0, 0);

  // bottom
  gl.glBegin(GL.GL_LINE_LOOP);
  gl.glVertex3f(0, 0, 0);
  gl.glVertex3f(0, 0, -1);
  gl.glVertex3f(1, 0, -1);
  gl.glVertex3f(1, 0, 0);
  gl.glEnd();

  // top
  gl.glBegin(GL.GL_LINE_LOOP);
  gl.glVertex3f(0, 1, 0);
  gl.glVertex3f(0, 1, -1);
  gl.glVertex3f(1, 1, -1);
  gl.glVertex3f(1, 1, 0);
  gl.glEnd();

  // left
  gl.glBegin(GL.GL_LINE_LOOP);
  gl.glVertex3f(0, 0, 0);
  gl.glVertex3f(0, 1, 0);
  gl.glVertex3f(0, 1, -1);
  gl.glVertex3f(0, 0, -1);
  gl.glEnd();

  // right
  gl.glBegin(GL.GL_LINE_LOOP);
  gl.glVertex3f(1, 0, 0);
  gl.glVertex3f(1, 1, 0);
  gl.glVertex3f(1, 1, -1);
  gl.glVertex3f(1, 0, -1);
  gl.glEnd();

  gl.glEndList();

  avatar_footprint = avatar + 1;

  gl.glNewList(avatar_footprint, GL.GL_COMPILE);

  //gl.glColor3f(0, 1.0, 0);

  // bottom
  gl.glBegin(GL.GL_QUADS);
  gl.glVertex3f(0, 0, 0);
  gl.glVertex3f(0, 0, -1);
  gl.glVertex3f(1, 0, -1);
  gl.glVertex3f(1, 0, 0);
  gl.glEnd();

  gl.glEndList();
}


void keyPressed()
{ 
  if (keyCode == UP)
  {
    if (render && DEBUG)
    {
      walkZ += 5;
    }
    else
    {
      if (menuState == 0) // main menu
      {
        highlightMenu--;
        highlightMenu = max(highlightMenu, 0);
      }
      if (menuState == 2) // choose name
      {
        charASCII++;
        if (charASCII > 90)
        {
          charASCII = 65;
        }
        highscoreName[charPos] = Character.toString((char)charASCII);
      }
    }
  }
  if (keyCode == DOWN)
  {
    if (render && DEBUG)
    {
      walkZ -= 5;
    }
    else
    {
      if (menuState == 0) // main menu
      {
        highlightMenu++;
        highlightMenu = min(highlightMenu, menu.length-1);
      }
      if (menuState == 2) // choose name
      {
        charASCII--;
        if (charASCII < 65)
        {
          charASCII = 90;
        }
        highscoreName[charPos] = Character.toString((char)charASCII);
      }
    }
  }
  if (keyCode == ENTER)
  {
    if (gameState == 0)
    {
      if (highlightMenu == 0) // START
      {
        gameOverSound.pause();
        gameOverSound.rewind();
        
        finishSound.pause();
        finishSound.rewind();
        
        menuSound.pause();
        
        walkZ = 0;
        renderBegin = 0;
        countdown = true;
        render = true;
        gameState = 1;
        charASCII = 65;
        charPos = 0;
      }
      if (highlightMenu == 1) // WORLD
      {
        if (menuState != 1)
        {
          menuState = 1; // choose world
        }
        else
        {
          loadWorldData();
          loadWorldInfo();
          menuState = 0; // default
        }
      }
      if (highlightMenu == 2) // HIGHSCORE
      {
        loadWorldHighscore();
        gameState = 3;
      }
      if (highlightMenu == 3) // QUIT
      {
        exit();
      }
    }
    if (gameState == 2 || gameState == 4)
    {
      charPos++;
      if (charPos < 3)
      {
        highscoreName[charPos] = Character.toString((char)charASCII);
      }
      else
      { 
        highscore.add(new HighscoreEntry(join(highscoreName, ""), walkZ));
        writeWorldHighscore();
        menuState = 0;
        gameState = 0;
        
        highscoreName[0] = "A";
        highscoreName[1] = "_";
        highscoreName[2] = "_";
        
        gameOverSound.pause();
        gameOverSound.rewind();
        
        finishSound.pause();
        finishSound.rewind();
        
        menuSound.loop();
      }
    }
  }
  
  if (keyCode == BACKSPACE)
  {   
    if (gameState == 3)
    {
      gameState = 0;
    }
  }

  if (keyCode == LEFT)
  {
    if (menuState == 1) // world select
      {
        selectedWorld--;
        selectedWorld = max(selectedWorld, 0);
      }
  }
  if (keyCode == RIGHT)
  {
    if (menuState == 1) // world select
      {
        selectedWorld++;
        selectedWorld = min(selectedWorld, worlds.length-1);
      }
  }
}

void oscEvent(OscMessage theOscMessage)
{
  if(theOscMessage.checkAddrPattern("/Field1") == true) {
    if(theOscMessage.checkTypetag("ffff")) {
      top = theOscMessage.get(0).floatValue();
      bottom = theOscMessage.get(1).floatValue();
      left = theOscMessage.get(2).floatValue();
      right = theOscMessage.get(3).floatValue();
      //println(top +" " + bottom + " " + left + " " + right);
    }
  }
}

/**
 * Check if two rectangles collide
 * x_1, y_1, width_1, and height_1 define the boundaries of the first rectangle
 * x_2, y_2, width_2, and height_2 define the boundaries of the second rectangle
 */
boolean rectangle_collision(float x_1, float y_1, float width_1, float height_1, float x_2, float y_2, float width_2, float height_2)
{
  return !(x_1 > x_2+width_2 || x_1+width_1 < x_2 || y_1 > y_2+height_2 || y_1+height_1 < y_2);
}

void stop()
{
  // always close Minim audio classes when you are done with them
  levelSound.close();
  gameOverSound.close();
  finishSound.close();
  menuSound.close();
  // always stop Minim before exiting.
  minim.stop();

  super.stop();
}

void loadWorldData()
{
  // load world
  worldLines = loadStrings(dataPath("")+"worlds/"+worlds[selectedWorld]+"/world.txt");
  world = new int[worldLines.length][boxCountX][3];
  // fill world array
  for (int i = 0; i != worldLines.length; i++)
  {
    String[] tiles = split(worldLines[i], ' ');
    for (int j = 0; j != tiles.length; j++)
    {
      String[] comp = split(tiles[j], ',');
      world[i][j] = int(comp);
    }
  }
  loadWorldHighscore();
}

void loadWorldHighscore()
{
  highscoreLines = loadStrings(dataPath("")+"worlds/"+worlds[selectedWorld]+"/highscore.txt");

  highscore = new ArrayList();

  // fill highscore list
  for (int i = 0; i != highscoreLines.length; i++)
  {
    String[] entry = split(highscoreLines[i], ',');
    highscore.add(new HighscoreEntry(entry[0], int(entry[1])));
  }
  
  Collections.sort(highscore);
}

void loadWorldInfo()
{
  infoLines = loadStrings(dataPath("")+"worlds/"+worlds[selectedWorld]+"/info.txt");
  
  try
  {
    tex = TextureIO.newTexture(new File(dataPath("")+"images/"+infoLines[0]), true);
  }
  catch(Exception e)
  { 
    println(e);
  }
  
  try
  {
    error = TextureIO.newTexture(new File(dataPath("")+"images/"+infoLines[1]), true);
  }
  catch(Exception e)
  { 
    println(e);
  }
  
  levelSound = minim.loadFile("sounds/"+infoLines[2]);
  
  String[] c = split(infoLines[3], ',');
  avatarColor = float(c); 
}

void writeWorldHighscore()
{
  output = createWriter(dataPath("")+"worlds/"+worlds[selectedWorld]+"/highscore.txt");
  
  for (HighscoreEntry entry : highscore)
  {
    output.println(entry.getName() + "," + entry.getScore());
  }
  output.flush(); // Writes the remaining data to the file
  output.close();
}


class HighscoreEntry implements Comparable<HighscoreEntry>
{
  String name;
  Integer score;

  HighscoreEntry(String n, int s) {
    name = n;
    score = s;
  }

  String getName() {
    return name;
  }

  int getScore() {
    return score;
  }

  String toString() {
    return name + " " + score;
  }

  public int compareTo(HighscoreEntry h) {
    return -score.compareTo(h.score); // using "-" is not good
  }
}
