const Synth = (function () {
    let p, notes, mode;

    function init() {

        mode = 0;
        notes = [];
        p = [];
        for (let i = 0; i < 8; i++) {
            p.push(new Tone.PolySynth(4, Tone.Synth).toMaster());
        }
       // p1 = new Tone.PolySynth(8, Tone.Synth).toMaster();
       // p2 = new Tone.PolySynth(8, Tone.Synth).toMaster();
       // p3 = new Tone.PolySynth(8, Tone.Synth).toMaster();
       // p4 = new Tone.PolySynth(8, Tone.Synth).toMaster();

    
        //p1.volume.value = -10;
        //p2.volume.value = -13;
        //p3.volume.value = -14;
        //p4.volume.value = -20;


    }

    //Expects data of legnth 32
    function processArray(cells) {

        if (mode === 0) {
            let data = [];
            for (let i = 0; i < 32; i++) {
                if (cells[i] === 1) {
                    data.push(notes[i]);
                }
            }
            p[0].triggerAttackRelease(data.slice(0, 4), '8n');
            p[1].triggerAttackRelease(data.slice(4, 8), '8n');
            p[2].triggerAttackRelease(data.slice(8, 12), '8n');
            p[3].triggerAttackRelease(data.slice(12, 16), '8n');
        } else {

            let data = [];
            for (let i = 0; i <32; i++) {
                if (i % 4 === 0) {
                data.push([]);
                }
                if (cells[i] === 1) {
                    data[Math.floor(i / 4)].push(notes[i]);
                }
            } 

            p[0].triggerAttackRelease(data[0], '8n');
            p[1].triggerAttackRelease(data[1], '8n');
            p[2].triggerAttackRelease(data[2], '8n');
            p[3].triggerAttackRelease(data[3], '8n');
            p[4].triggerAttackRelease(data[4], '8n');
            p[5].triggerAttackRelease(data[5], '8n');
            p[6].triggerAttackRelease(data[6], '8n');
            p[7].triggerAttackRelease(data[7], '8n');
        }
    }

    function changeMode(m) {
        mode = m;
    }


    function setScale(s) {
        notes = [];
        let prefixes = s;
        for (let i = 0; i < 32; i++) {
            notes.push(prefixes[i % 5] + (Math.floor(i / 5) + 1));
        }
    }

    function updateVolume(i, v) {
        p[i].volume.value = v;
     
    }

    return  {
        init,
        processArray,
        setScale,
        updateVolume,
        changeMode
    };
}());