const Gui = (function () {
    let activeScale, activeRule;

    function init() {
        activeScale = null;
        let anchorScales = document.createElement('div');
        anchorScales.classList.add('scales');

        let major = document.createElement('h2');
        major.innerText = 'major';
        anchorScales.appendChild(major);

        Object.keys(Scales.major).forEach(function (key) {
            
            let p = document.createElement('p');
            p.innerText = key;
            p.onclick = function () {
                if (p.classList.contains('active')) {
                    return;
                }
                p.classList.add('active');
                if (activeScale) {
                    activeScale.classList.remove('active');
                }
                activeScale = p;
                Synth.setScale(Scales.major[key]);
            };
            anchorScales.appendChild(p);
            if (key === 'C') {
                p.click();
            }
        });

        let minor = document.createElement('h2');
        minor.innerText = 'minor';
        anchorScales.appendChild(minor);

        Object.keys(Scales.minor).forEach(function (key) {
            let p = document.createElement('p');
            p.innerText = key;
            p.onclick = function () {
                if (p.classList.contains('active')) {
                    return;
                }
                p.classList.add('active');
                if (activeScale) {
                    activeScale.classList.remove('active');
                }
                activeScale = p;
                Synth.setScale(Scales.minor[key]);
            };
            anchorScales.appendChild(p);
        });

        document.body.appendChild(anchorScales);

        activeRule = null;

        let anchorRules = document.createElement('div');
        anchorRules.classList.add('rules');
        
        let heading = document.createElement('h2');
        heading.innerText = 'rules';
        anchorRules.appendChild(heading);
        Object.keys(Rules).forEach(function (key) {
            let p = document.createElement('p');
            p.innerHTML = '<b>'+ key + '</b><br>[' + Rules[key].join(',') + ']';
            p.onclick = function () {
                if (p.classList.contains('active')) {
                    return;
                }
                p.classList.add('active');
                if (activeRule) {
                    activeRule.classList.remove('active');
                }
                activeRule = p;
                Automata.setRules(Rules[key]);
            };
            anchorRules.appendChild(p);
            if (key === '30') {
                p.click();
            }
        });

        document.body.appendChild(anchorRules);


        let sliderAnchor = document.createElement('div');
        sliderAnchor.classList.add('slider');
        for (let i = 0; i < 8; i++) {
            let div = document.createElement('div');
            div.classList.add('box')
            let p = document.createElement('p');
            p.innerHTML = '<b>p' + i + '</b>';
            let input = document.createElement('input');
            input.type = 'range';
            input.min = -100;
            input.max = 0;
            input.value = -100;
            function update() {
                Synth.updateVolume(i, input.value);
            }
            input.addEventListener('keydown', update);
            input.addEventListener('mousemove', update);
            input.addEventListener('change', update);
            update();
            div.appendChild(p);
            div.appendChild(input);
            sliderAnchor.appendChild(div);
        }
        document.body.appendChild(sliderAnchor);

        let modeBox = document.createElement('div');
        modeBox.classList.add('mode');
        let p = document.createElement('p');
        p.innerText = 'bug-mode: ';
        
        modeBox.appendChild(p);
        let mode = document.createElement('input');
        mode.type = 'checkbox';
        mode.addEventListener('change', function () {
            Synth.changeMode(mode.checked ? 1 : 0);
        });

        modeBox.appendChild(mode);
        document.body.appendChild(modeBox);
    }

    return {
        init
    }
}());