const Automata = (function () {
    let rule, canvas, context, now, last, patterns, mouse, down;

    function init() {
        patterns = {};
        patterns['111'] = 0;
        patterns['110'] = 1;
        patterns['101'] = 2;
        patterns['100'] = 3;
        patterns['011'] = 4;
        patterns['010'] = 5;
        patterns['001'] = 6;
        patterns['000'] = 7;

        mouse = {x: 0, y: 0};
        down = false;
    
        
        canvas = document.createElement('canvas');
        context = canvas.getContext('2d');

        canvas.style.imageRendering = 'pixelated';
        canvas.width = 32;
        canvas.height = 32;

        window.addEventListener('mousedown', function (e) {
            down = true;
            mouse = getMousePos(canvas, e);
        });

        window.addEventListener('mouseup', function () {
            down = false;
        });

        document.querySelector('.container').appendChild(canvas);

        last = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0];
        now = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

    }
    function  getMousePos(canvas, e) {
        let rect = canvas.getBoundingClientRect(), // abs. size of element
            scaleX = canvas.width / rect.width,    // relationship bitmap vs. element for X
            scaleY = canvas.height / rect.height;  // relationship bitmap vs. element for Y
      
        return {
          x: (e.clientX - rect.left) * scaleX,   // scale mouse coordinates after they have
          y: (e.clientY - rect.top) * scaleY     // been adjusted to be relative to element
        }
      }

    function frame() {
        update();
        draw();
    }

    function update() {
        let mi = null;
        if (down) {
            if (mouse.y > 31 && mouse.y < 32) {
                mi = Math.round(mouse.x);
            }
        }

        for(let i = 0; i < 32; i++) {

            let l = typeof(last[i - 1]) !== 'undefined' ? last[i - 1] : last[31];
            let c = last[i];
            let r = typeof(last[i + 1]) !== 'undefined' ? last[i + 1] : last[0];

            now[i] = rule[patterns[l.toString() + c.toString() + r.toString()]];
            if (mi === i) {
                now[i] = 1;
            }
        }
    }

    function draw() {
        let imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        context.putImageData(imageData, 0, -1);
        
        for(let i = 0; i < 32; i++) {
            context.fillStyle = now[i] > 0 ? '#212121' : 'white';
            context.fillRect(i, 31, 1, 1);
        }
        last = now;
        now = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    }

    function setRules(r) {
        rule = r;
    }

    function getCells() {
        return last;
    }

    return  {
        init,
        frame,
        getCells,
        setRules,
        update,
        draw
    };
}());