import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class Form_und_Raum extends PApplet {

Segmente[] objekt = new Segmente[9];

public void setup() {
  size(768, 768);
  smooth();
  noStroke();
  //frameRate(25);
  colorMode(HSB,360,100,100,100);
  
  for (int i=0; i < objekt.length; i++) {
    objekt[i] = new Segmente(); //Konstrukror
  }
}

public void draw() {
  background(0);
  //male die Objekte nur wenn sie aktiviert bzw. sichtbar sind
  for (int i=0; i < objekt.length; i++) {
    if (objekt[i].visible) {
      objekt[i].maleSegmente();
    }
  }
  //pr\u00fcfe ob die Maus \u00fcber dem Objekt ist
  for (int i=0; i < objekt.length; i++) {
    if ((mouseX >= objekt[i].x-objekt[i].r) && (mouseX <= objekt[i].x+objekt[i].r) && (mouseY >= objekt[i].y-objekt[i].r) && (mouseY <= objekt[i].y+objekt[i].r)) {
      objekt[i].mouseOver = true;
    }else {
      objekt[i].mouseOver = false;
    }
  }
}

public void mouseDragged() { //ver\u00e4ndere die Position des ausgew\u00e4hlten Objekts
  for (int i=0; i < objekt.length ; i++) {
    if (objekt[i].mouseOver) {
      objekt[i].x = mouseX;
      objekt[i].y = mouseY;
      break;
    }
  }
}

public void keyPressed() {
  int k = (int)key-48-1; //Zahlenverschiebung: '1' entspricht objekt[0]
  //aktiviere bzw. mache das Objekt mit der jeweiligen Zahl sichtbar
  if ((k >= 0) && (k < objekt.length)) {
    if (objekt[k].visible == false) {
      objekt[k].visible = true;
    }else if (objekt[k].visible) { //oder wieder unsichtbar
      objekt[k].visible = false;
    }
  }
  //ver\u00e4ndere die Segmentzahl oder Farbe des ausgew\u00e4hlten Objekts (UP,DOWN,LEFT,RIGHT)
  if (key == CODED) {
    for (int i=0; i < objekt.length; i++) {
      if (objekt[i].mouseOver) {
        if (keyCode == UP) {
          if (objekt[i].seg <= 100) {
            objekt[i].seg += 1;
          }
        }
        if (keyCode == DOWN) {
          if (objekt[i].seg >= 1) {
            objekt[i].seg -= 1;
          }
        } 
        if (keyCode == RIGHT) {
          if (objekt[i].h <= 360) {
            objekt[i].h += 1;
          }
        }
        if (keyCode == LEFT) {
          if (objekt[i].h >= 1) {
            objekt[i].h -= 1;
          }
        }
      }
    }
  }
  //ver\u00e4ndere Radius (+,-), Alphawert (,,.) und Gradzahl bzw. Richtung (/,*) des Objekts
  for (int i=0; i < objekt.length; i++) {
    if (objekt[i].mouseOver) {
      if (key == '+') {
        if (objekt[i].r <= 200) {
          objekt[i].r += 1;
        }
      }
      if (key == '-') {
        if (objekt[i].r >= 50) {
          objekt[i].r -= 1;
        }
      } 
      if (key == ',') {
        if (objekt[i].a <= 100) {
          objekt[i].a += 1;
        }
      }
      if (key == '.') {
        if (objekt[i].a >= 10) {
          objekt[i].a -= 1;
        }
      }
      if (key == '/') {
        if (objekt[i].g <= 360) {
          objekt[i].g += 1;
        }
      }
      if (key == '*') {
        if (objekt[i].g >= 1) {
          objekt[i].g -= 1;
        }
      }
    }
  }
  //erzeuge Zufallswerte bei allen Objekten (ENTER)  
  if (key == ENTER || key == RETURN) {
    for (int i=0; i < objekt.length; i++) {
      objekt[i].x = random(width);
      objekt[i].y = random(height);
      //bessere Verteilung der Werte bzw. weniger Kreise
      switch((int)random(4)) {
        case 0:
          objekt[i].seg = (int)random(6);
          break;
        case 1:
          objekt[i].seg = (int)random(6,12); 
         break; 
        case 3:
          objekt[i].seg = (int)random(12,100);
          break;
        default:
          break;
      }
      objekt[i].r = (int)random(50,100);
      objekt[i].g = random(360);
      
      objekt[i].h = (int)random(360);
      objekt[i].a = (int)random(50,100);
    }
  }
  //aktiviere die Bewegung aller Objekte (0)
  for (int i=0; i < objekt.length; i++) {
    if ((key == '0') && (objekt[i].move == false)) {
      objekt[i].move = true;
    }else if ((key == '0') && (objekt[i].move)) { //oder deaktiviere sie
      objekt[i].move = false;
    }
  }
}

public void mouseMoved() { //bewege alle Objekte, au\u00dfer das ausgew\u00e4hlte, frei im Raum
  for (int i=0; i < objekt.length; i++) {
    if ((objekt[i].move == true) && (objekt[i].mouseOver == false)) {
      objekt[i].x = objekt[i].x + objekt[i].sx;
      objekt[i].y = objekt[i].y + objekt[i].sy;
      //drehe das Objket
      objekt[i].g = objekt[i].g + 1;
      if (objekt[i].g >= 360) {
        objekt[i].g = 0;
      }
      //wechsel die Bewegungsrichtung, wenn das Objekt an den Rand st\u00f6\u00dft
      if (objekt[i].x >= width || objekt[i].x <= 0){
        objekt[i].sx = -objekt[i].sx;
      }
      if (objekt[i].y >= height || objekt[i].y <= 0){
        objekt[i].sy = -objekt[i].sy;
      }
    }
  }
}

class Segmente {
  
  float x; // X-Position
  float y; // Y-Position
  
  int seg; // Segmentz\u00e4hler
  int r; // Radius
  float g; // Richtung bzw. Grad
  
  boolean mouseOver; //Maus \u00fcber dem Objekt
  boolean visible; //Objekt sichtbar
  boolean move; //Objekt bewegt sich
  
  int h,s,b,a; // Farbe HSB und Alpha
  
  float sx,sy; //Geschwindigeit
  
  Segmente() {
    //println("Segmente erstellt!");
    x = random(100,width-100);
    y = random(100,height-100);
    
    seg = (int)random(6);
    r = 100;
    g = 90; // Richtung nach oben
    
    h = (int)random(360);
    s = 100;
    b = 100;
    a = 100;
    
    mouseOver = false;
    visible = true;
    move = false;
    
    sx = 5;
    sy = 5;
  }
  
  public void maleSegmente() {
    fill(h,s,b,a);
    maleSegmente(seg,r,g,x,y);
  }
  
  //abgewandelte Funktion aus dem Buch "Generative Gestaltung" Seite 187
  public void maleSegmente(int seg,int r,float g,float x,float y) {
    float segmentzahl = 3 + (float)seg;
    float angleStep = 360/segmentzahl;
    //zeichnet Linien \u00fcber die berechneten Punkte auf der \u00e4u\u00dferen Kreisbahn
    beginShape();
    vertex(x, y); 
    for (float angle=0; angle<=360; angle+=angleStep) {
      float vx = x + cos(radians(angle-g))*r;
      float vy = y + sin(radians(angle-g))*r;
      vertex(vx, vy);
    }
    vertex(x + cos(radians(360-g))*r, y + sin(radians(360-g))*r);
    endShape();
  }
}
  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#666666", "--stop-color=#cccccc", "Form_und_Raum" });
  }
}
