import peasy.*;

PeasyCam cam;

PImage cat;
PImage notCat;
int Div = 5;
float Count = 0.015;


void settings() {
  notCat = loadImage("ND.jpg");
  
  cat = loadImage("diane.jpg");
  size(cat.width, cat.height, P3D);
  notCat.resize(width,height);
}

void setup() {

  cam = new PeasyCam(this, 100);
  cam.setMinimumDistance(500);
  cam.setMaximumDistance(5000);

  translate(width/2, height/2, 0);

  frameRate(24);
}

void draw() {
  rotateX(-.5);
  rotateY(-.5);
  background(0);


  pushMatrix();
  rotateX(radians(90));
  rotateY(radians(90));
  drawDemOrb(cat);
  drawDemOrb(notCat);
  popMatrix();
}

void drawDemOrb(PImage img) {
  for (int i = Div; i<width; i+=Div) {
    for (int j = Div; j < height; j+=Div) {

      color c = color(img.get(i, j));
      float bri = brightness(c);
      float sat = map(saturation(c), 0, 255, 0, bri);
      float r = red(c);
      float g = green(c);
      float b = map(blue(c), 0, 255, 1, 25);

      color opC = color(abs(r-255), abs(g-255), abs(b-255));

      //g = map(g,0,255,0,100);

      float briSin = sin(sat + ((Count)/10))*.05;

      float mod = map(mouseX, 0, width, 0, 1);

      pushMatrix();
      translate(i-width/2, j-height/2);
      strokeWeight(b*mod);
      stroke(c);
      point(0, 0, bri*mod);

      popMatrix();
      strokeWeight(1);

      Count++;
    }
  }
}

void keyPressed(){
  
  if(key == ENTER){
   saveFrame("dotty_####.png"); 
  }
  
  
}
