class Balloon {
  //Attributes
  float x;
  float y;
  float size;
  float speed;
  color c;

  //Constructor
  Balloon(float tempX, float tempY, float tempSize) {
    x = tempX;
    y = tempY;
    size = tempSize;
    speed = .5;
    c = color(0, 30);
  }

  //Functions
  void update() {
    drawSelf();
    rise();

    checkBorder();
    moveNoiseDir(200,10);
  }

  void moveNoiseDir(float smooth, float scale) {
    float angle = (noise(x/smooth, y/smooth))*TWO_PI*scale;

    x+= cos(angle)*speed+.6;
    y+= sin(angle)*speed+.6;
  }

  void drawSelf() {
    fill(c);
    noStroke();
    ellipse(x, y, size, size);
  }

  void rise() { 
    y-=speed;
  }
  void windNoise(float strength, float smooth) {
    float wind = (noise(x/smooth, y/smooth)-0.5)*strength;

    x+=wind;
  }
  void windRandom(float strength) {
    x+=random(-strength, strength);
  }

  void windSine(float strength) {
    x += sin(frameCount/50.0) * strength;
  }

  void checkBorder() {
    if (y<-size/2) {
      y=height + size/2;
    }
  }
}
