import hpglgraphics.*;
import processing.serial.*;


Serial myPort;

PImage selfie;

Boolean penDown=false;



ArrayList<PVector> pPixWhite = new ArrayList<PVector>();
ArrayList<PVector> pPixGray = new ArrayList<PVector>();
ArrayList<PVector> pPixBlack = new ArrayList<PVector>();

//Balloon oneBalloon;

void setup() {

  size(1240, 874);
  selfie = loadImage("Cat.png");

  HPGLGraphics hpgl = (HPGLGraphics) createGraphics(width, height, HPGLGraphics.HPGL);

  hpgl.setPaperSize("A4");

  hpgl.setPath("postCardSelfieDots_White.hpgl");
  beginRecord(hpgl);
  noFill();
  for (int i = 0; i < width; i+=10) {
    for (int j = 0; j < height; j+=10) {

      color tempCol = selfie.get(i, j);

      if ((i<(width/2)-20 || i>(width/2)+20)) {
        if (j<(height/2)-20 || j>(height/2)+20) {


          if (red(tempCol) < 255 && red(tempCol)>190
            && blue(tempCol) < 255 && blue(tempCol)>190
            && green(tempCol)< 255 && green(tempCol)>190) {
            pPixWhite.add(new PVector(i, j));
          } // White

          if (red(tempCol) <90 && red(tempCol)>0
            && blue(tempCol) < 90 && blue(tempCol)>0
            && green(tempCol)< 90 && green(tempCol)>0) {
            pPixBlack.add(new PVector(i, j));
          } // Black

          if (red(tempCol) <160 && red(tempCol)>120
            && blue(tempCol) < 160 && blue(tempCol)>120
            && green(tempCol)< 160 && green(tempCol)>120) {
            pPixGray.add(new PVector(i, j));
          } //Gray
        }
      }
    }
  }
}

void draw() {
  background(0);
  noFill();
  strokeWeight(1);

  for (int i = 0; i < pPixWhite.size(); i++) {
    pushMatrix();
    translate(pPixWhite.get(i).x, pPixWhite.get(i).y);
    rotate(radians(30));
    stroke(76,255,228);
    ellipse(0, 0, 5, 15);
    fill(76,255,228);
    ellipse(0, 0, 2, 2);
    noFill();
    popMatrix();
  }

  for (int i = 0; i < pPixBlack.size(); i++) {
    if (pPixBlack.get(i).x>20 && pPixBlack.get(i).x<width-20) {
      if (pPixBlack.get(i).y>20 && pPixBlack.get(i).y<height-40) {
        pushMatrix();
        translate(pPixBlack.get(i).x, pPixBlack.get(i).y);
        stroke(180);
        line(-4, 4, 4, -4);
        popMatrix();
      }
    }
  }

  for (int i = 0; i < pPixWhite.size(); i++) {

    for (int j = -20; j<=20; j+=5) {
      for (int k = -20; k<=20; k+=5) {
        PVector tempPoint = new PVector(pPixWhite.get(i).x+j, pPixWhite.get(i).y+k);
        color tempCol = selfie.get((int)tempPoint.x+j, (int)tempPoint.y);

        if (red(tempCol) < 60 && red(tempCol) > 50) {
          stroke(255);
          line(tempPoint.x, tempPoint.y, pPixWhite.get(i).x, pPixWhite.get(i).y);
        }
      }
    }
  }


  noLoop();
  //}
}

void mousePressed() {

  endRecord();
  saveFrame("Noisey_####.png");
}
