// Timer
// (cc)2012 by Michael Markert, audiocommander.de

// strings
var h, m, s;	// remaining time
var ch, cm, cs;	// current time

// dates
var currentTime = null;
var destinationTime = null;
var remainingTime = null;

// elements
var timebar;
var timebarindicator;
var timeremain;
var timecurrent;

// misc
var remainingMinutes = 5;
var remainingPercent = 100;
var overdue = false;


window.onload = function() {
	
	timebar = document.querySelector("#timebar");
	timebarindicator = document.querySelector("#timebarindicator");
	timeremain = document.querySelector("#timeremain");
	timecurrent = document.querySelector("#timecurrent");
	
	window.onkeyup = function(e) {
		var key = e.keyCode -48;
		setTimer(key);
		e.preventDefault();
	}
	
	// for touch devices
	window.ontouchmove = function(e) { e.preventDefault(); }
/*	window.ongestureend = function(e) {
		var scale = e.scale;
		if(scale < 1) {
			remainingMinutes--;
		} else {
			remainingMinutes++;
		}
		setTimer(remainingMinutes);
		e.preventDefault;
	} */
	document.querySelector("#increasetime").ontouchstart = function(e) {
		setTimer(remainingMinutes+1);
	}
	document.querySelector("#decreasetime").ontouchstart = function(e) {
		setTimer(remainingMinutes-1);
	}
	
	// start the time
	setTimer(5);
}

// set timer with minutes and start countdown
// newTime should must in range 1 to 9 minutes
function setTimer(newTime) {
	if(newTime > 0 && newTime < 10) {
		remainingMinutes = newTime;
		console.log("Setting new Timer: " + remainingMinutes);
		// reset overdue
		overdue = false;
		document.body.style.backgroundColor = "#000";
		// get current Date
		var now = new Date();
		destinationTime = new Date();
		destinationTime.setMinutes( now.getMinutes() + remainingMinutes );
		destinationTime.setSeconds( now.getSeconds() + 1 );
		countTime();
	}
}


// calculates times and displays countdown & current time

function countTime() {

	currentTime = new Date();

	// remaining time
	remainingTime = new Date(destinationTime - currentTime);
	if(destinationTime < currentTime) {
		overdue = true;
		remainingTime = new Date(currentTime - destinationTime);
		remainingPercent = 0;
	} else {
		overdue = false;
		remainingPercent = 100/(remainingMinutes*60) * (remainingTime.getMinutes() * 60 + remainingTime.getSeconds());
	}
	
	// overdue
	var spanstart = "";
	var spanend = "";
	if(overdue) {
		spanstart = '<span class="overdue">+';
		spanend = '</span>';
		timebarindicator.className = "overduebar";
		remainingPercent = 100;
	} else {
		timebarindicator.className = "";
	}
	if(overdue && remainingTime.getMinutes() >= 1) {
		// extreme overdue!
		spanstart = '<span class="extremeoverdue">+';
		spanend = '</span>';
		var r = Math.floor(Math.random()*155)+100;
		var g = 0;
		var b = 0;
		var bgstyle = "rgb("+r+","+g+","+b+")";
		document.body.style.backgroundColor = bgstyle;
		timebarindicator.className = "extremeoverduebar";
		remainingPercent = 100;
	}
	
	// remaining time
	m = twoDigits(remainingTime.getMinutes());
	s = twoDigits(remainingTime.getSeconds());
	// current time
	ch = twoDigits(currentTime.getHours());
	cm = twoDigits(currentTime.getMinutes());
	cs = twoDigits(currentTime.getSeconds());
	
	// show the time
	timeremain.innerHTML = spanstart + m + ":" + s + spanend;
	timecurrent.innerHTML = ch + ":" + cm + ":" + cs;
	timebarindicator.style.width = remainingPercent + "%";
		
	// come again
	t = setTimeout('countTime()', 200);
}

function twoDigits(i) {
	if (i<10) {
  		i = "0" + i;
	}
	return i;
}
