var CURRENTFRAME = 1;
var CURRENTCHILD;
	
$(document).ready(function(){
	$("#ifdlightbox").hide();
	$("#ifdlightbox .close").click(function(){
		lightboxStop();
	});
	$(window).mousemove(function(){
		// naviFadeIn()
		$(window).stopTime().oneTime(2000, function() {
			// naviFadeOut();
		});
	})
	
	$(window).keyup(function(e){
		//alert(e.keyCode)
		switch(e.keyCode)
		{
			// down or right
			case 39:
				changeFrame("next");
				break;
			case 40:
				changeFrame("next");
				break;

			// up or left
			case 37:
				changeFrame("prev");
				break;
			case 38:
				changeFrame("prev");
				break;

			// ESC
			case 27:
				lightboxStop();
				break;
		}
	})
	
	$("a").click(function(e)
	{
		e.preventDefault();
		loadContent($(this))
	})
})

function loadContent(child)
{
	if(child)
	{
		CURRENTCHILD = child;
		CURRENTFRAME = 1;
		var url = CURRENTCHILD.attr("href");
	
		lightboxInit();
		
		var article = url.substr(url.search(/wiki\/.+/) + 5);;
		$.ajax({
			url: "loadContent.php?a=" + article,
			success: function(data){
				var articleContent = document.createElement('div')
					$(articleContent).html(data);
				
				var resultHTML = createTitle( $(articleContent).find('h2').text(), $(articleContent).find('h3').text(), $(articleContent).find('h4').text() );
				resultHTML += createScreens(articleContent);
				resultHTML += createEndFrame();
				lightboxStart(resultHTML);
		}
		});
		
	}
}



function createTitle(title, name, info)
{
	var str = "<div class='frame titleframe'>"
		str += "<h1>" + title + "</h1><h2>"+ name + "</h2><h3>" + info + "";
		str += "</div>";
		return str;
}
function createScreens(articleContent)
{
	var resultStr = "";
	$(articleContent).find('a').each(function(index, value)
	{
		if($(value).find("img").attr("src") != undefined)
		{
			resultStr += "<div class='frame'><img height='100%' src='" + $(value).find("img").attr("src") + "'></div>";
		} else {
			var href = $(value).attr("href")
			
			if( href.search(/vimeo.+/) != -1 )
			{
				var start = href.lastIndexOf(".com/") + 5;
				href = href.substring(start)
				resultStr += '<div class="frame vid"><iframe src="http://player.vimeo.com/video/' + href + '?title=0&amp;byline=0&amp;portrait=0&autoplay=1" width="100%" height="100%" frameborder="0" wmode="transparent"></iframe></div>';
			}
			else if( href.search(/youtube.+/) != -1 )
			{
				var start = href.lastIndexOf("?v=") + 3;
				var end = href.indexOf("&");
				if(end == -1) href = href.substring(start);
				else href = href.substring(start, end)
	
				resultStr += "<div class='frame vid'><embed width='100%' height='100%' name='plugin' src='http://www.youtube.com/v/"+href+"?fs=1&amp;amp;hl=de_DE&amp;amp;rel=0&autoplay=1' type='application/x-shockwave-flash' wmode='transparent' ></div>"
			}
			else{
				resultStr += '<div class="frame vid"><iframe src="' + href + '" width="100%" height="100%" frameborder="0" wmode="transparent"></iframe></div>';

			}
		}
	})
	return resultStr;
}
function createEndFrame()
{
	return "<div class='frame centerframe'>||ende||</div>";
}

function lightboxInit(){
	$("#ifdlightbox").fadeIn("fast");
	$("#ifdlightbox .wrapper").html("<div class='frame centerframe'><img src='images/ajax-loader.gif'></div>");
	$("body").css({"overflow": "hidden"})
}

function lightboxStart(htmlContent)
{
	$("#ifdlightbox .wrapper").html(htmlContent);
	$("#ifdlightbox .wrapper .frame").hide();
	$("#ifdlightbox .frame:nth-child(1)").show();
}
function lightboxStop(){
	$("#ifdlightbox").fadeOut("fast");
	$("body").css({"overflow": "auto"})
}
function changeFrame(direction)
{
	var next = false;
	var prev = false;
	if(direction == "next")
	{
		CURRENTFRAME++;
		if (CURRENTFRAME > $("#ifdlightbox .wrapper .frame").length) {
			CURRENTFRAME--;
			next = true;
		}
	}
	else{
		CURRENTFRAME--;
		if (CURRENTFRAME < 1) {
			CURRENTFRAME = 1;
			prev = true;
		}
	}
	if (!prev && !next) {
		$("#ifdlightbox .wrapper .frame").fadeOut("fast");
		$("#ifdlightbox .wrapper .frame:nth-child("+CURRENTFRAME+")").fadeIn("fast");
	}
	else if(next)
	{
		var nextChild = CURRENTCHILD.parent().next().children("a");
		if(nextChild.attr("href") == undefined) lightboxStop();
		else{
			loadContent(nextChild)
		}
	}
	else if(prev)
	{
		var prevChild = CURRENTCHILD.parent().prev().children("a");
		if(prevChild.attr("href") == undefined) lightboxStop();
		else{
			loadContent(prevChild)
		}
	}
}

function naviFadeOut()
{
	$("#ifdlightbox .navi").fadeOut("fast");
	//$(window).css("cursor", "url(images/cursor1px)")
}
function naviFadeIn()
{
	$("#ifdlightbox .navi").fadeIn("fast");
	//$(window).css("cursor", "auto")
}