
/*
 *
 * (c) bu ifd 2014
 *
*/



THREE.ViewControl = function (camera, object, domElement) {

	var scope = this;

	scope.camera = ( camera !== undefined ) ? camera : camera;
	scope.object = object;
	scope.domElement = ( domElement !== undefined ) ? domElement : document;
	scope.windowWidth = window.innerWidth;
	scope.windowHeight = window.innerHeight;
	var lastX = currentX = 0;
	var lastY = currentY = 0;
	var zoomDelta = 0;


	
	scope.domElement.addEventListener( 'mousedown', onMouseDown, false );
	scope.domElement.addEventListener( 'mousewheel', onMouseWheel, false );

	function onMouseDown(e){

		currentX = lastX = e.clientX;
		currentY = lastY = e.clientY;

		scope.domElement.addEventListener( 'mousemove', onMouseMove, false );
		scope.domElement.addEventListener( 'mouseup', onMouseUp, false );

		
	}

	function onMouseMove(e){
		e.preventDefault();
		currentX = e.clientX;
		currentY = e.clientY;
	}

	function onMouseUp(e){
		e.preventDefault();
		scope.domElement.removeEventListener( 'mousemove', onMouseMove, false );
		scope.domElement.removeEventListener( 'mouseup', onMouseUp, false );
	}

	function onMouseWheel(e){
		e.preventDefault();
		e.stopPropagation();
		zoomDelta = e.wheelDelta / 100;

	}

	scope.update = function(){
		viewSettings.modelRotY += (currentX - lastX) / 300;
		viewSettings.cameraY += (currentY - lastY) / 50;
		viewSettings.cameraZ += zoomDelta;
		lastX = currentX;
		lastY = currentY;
		zoomDelta = 0;
	}


}


THREE.ViewControl.prototype = Object.create( THREE.EventDispatcher.prototype );
