
/*
 *
 * (c) bu ifd 2014
 *
*/



THREE.ModelLoader = function () {


    modelWrapper = new THREE.Object3D();
    scene.add(modelWrapper);


    var loader = new THREE.SceneLoader();        
    loader.load( itemModelPath, function ( loadedScene ) {

    	console.log(loadedScene);

        function generateTexture(name, obj){

        	if(obj.material.map){
	            var can = document.createElement( 'canvas' );
	            can.width = 1024;
	            can.height = 1024;
	            var ctx = can.getContext( '2d' );
	            ctx.rect(0,0,1024,1024);
	            ctx.fillStyle = getColor(name);
	            ctx.fill();

	            var texture = new THREE.Texture(can)

	                var img = new Image();
	                img.src = obj.material.map.sourceFile;
	                img.onload = function(){
	                    ctx.drawImage(img,0,0,img.width,img.height,0,0,1024,1024);
	                    texture.needsUpdate = true;
	                }

	            return texture;
        	}
        	else
        	{
        		return null;
        	}
        }

        function getColor(name){
        	if(!obj.material.map){
	            var col = "white";

	            if(name.indexOf("colB") > -1) col = colB;
	            else if(name.indexOf("colS") > -1) col = colS;
	            else if(name.indexOf("colR") > -1) col = colR;
	            else if(name.indexOf("colG") > -1) col = colG;

	            return col;
        	}
        	else
        	{
        		return null;
        	}
        }

        function getShading(name){
            var shad = THREE.SmoothShading;
            if(name.indexOf("shadF") > -1) shad = THREE.FlatShading;
            return shad;
        }

        function getNormalMap(obj){
        	if(obj.material && obj.material.bumpMap)
        	{
        		return THREE.ImageUtils.loadTexture(obj.material.bumpMap.sourceFile);
        	}
        	else
        	{
        		return null;
        	}
        }


        for( var name in  loadedScene.objects){
            var obj = loadedScene.objects[name];

            obj.material = new THREE.MeshPhongMaterial( { 
                color: getColor(name),
                map: generateTexture(name, obj),
                shading: getShading(name),
                normalMap: getNormalMap(obj),
                // ambiente: 0x000000,
                // specular: 0xffffff,
                shininess: 20
            });

            obj.side = THREE.DoubleSide;
            modelWrapper.add( obj );
        }

        //     // specularMap: imgBump,
        //     specular: 0xffffff, //highlight
        //     shininess: 9,
        //     // metal: true,
        //     shading: THREE.FlatShading
        // } )
        // mesh.side = THREE.DoubleSide;



    } );
}