
/*
 *
 * (c) bu ifd 2014
 *
*/



THREE.Debuging = function () {

	
    // add grid
    var sceneGrid = new THREE.Mesh( new THREE.PlaneGeometry( 100, 100, 10, 10 ), new   THREE.MeshBasicMaterial( { color: "white", wireframe: true } ) );
    sceneGrid.rotation.x = 90 * Math.PI/180;
    scene.add(sceneGrid);


    // add cube to origin
    var sceneOriginCube = new THREE.Mesh(new THREE.BoxGeometry(1,1,1), new THREE.MeshBasicMaterial({color:"red"}));
    scene.add( sceneOriginCube );


    // add stats
    var stats = new Stats();
    stats.setMode(0);
    stats.domElement.style.position = 'absolute';
    stats.domElement.style.left = '0px';
    stats.domElement.style.top = '0px';
    document.body.appendChild( stats.domElement );
    setInterval( function () {
        stats.begin();
        stats.end();
    }, 1000 / 60 );


    // add controls

    var datOptions = {
        printPOI: function(){
            alert( "[" + 
                (Math.round(camera.position.x*100)/100) + "," +
                (Math.round(camera.position.y*100)/100) + "," +
                (Math.round(camera.position.z*100)/100) + "," +
                (Math.round(modelWrapper.position.x*100)/100) + "," +
                (Math.round(modelWrapper.position.y*100)/100) + "," +
                (Math.round(modelWrapper.position.z*100)/100) + "," +
                (Math.round(modelWrapper.rotation.x*1000)/1000) + "," +
                (Math.round(modelWrapper.rotation.y*1000)/1000) + "," +
                (Math.round(modelWrapper.rotation.z*1000)/1000) +
                "]" );
        },
        printLight: function(){
            prompt = '';
            for( var i in lights)
            {
                prompt += "[" + lights[i].position.x;
                prompt += "," + lights[i].position.y;
                prompt += "," + lights[i].position.z;
                prompt += "," + lights[i].intensity + "]";
                if(i < lights.length-1) prompt += ",";
            }
            alert( "[" + prompt + "]" );
        },
        getPNG: function(){
            for(var i in lights){lights[i].shadowCameraVisible = false;}
            sceneGrid.visible = sceneOriginCube.visible = false;
            setTimeout(function(){
                window.open(renderer.domElement.toDataURL("image/png"));
            }, 100)
            setTimeout(function(){
                for(var i in lights){ lights[i].shadowCameraVisible = true;}
                sceneGrid.visible = sceneOriginCube.visible = true;
            }, 500)
        },
        getPNGThumb: function(){
            for(var i in lights){ lights[i].shadowCameraVisible = false; }
            sceneGrid.visible = sceneOriginCube.visible = false;
            setTimeout(function(){
                // extract area
                var can = document.createElement( 'canvas' );
                can.width = 720;
                can.height = 402;
                var ctx = can.getContext( '2d' );
                var img = document.createElement("img");
                img.src = renderer.domElement.toDataURL("image/png");
                ctx.drawImage(img,790,170,720,402,0,0,720,402)
                
                // resize
                canThumb = document.createElement('canvas');
                canThumb.width = 360;
                canThumb.height = 201;
                var ctxThumb = canThumb.getContext( '2d' );
                ctxThumb.drawImage(can,0,0,720,402,0,0,360,201)

                window.open(canThumb.toDataURL("image/png"));
            }, 100)
            setTimeout(function(){
                for(var i in lights){
                    lights[i].shadowCameraVisible = true;
                }
                sceneGrid.visible = sceneOriginCube.visible = true;
            }, 500)
        },
        removeGrids: function(){
            for(var i in lights){ lights[i].shadowCameraVisible = false; }
            sceneGrid.visible = sceneOriginCube.visible = false;
        },
        selectLight: 0,
        lightX: lights[0].position.x,
        lightY: lights[0].position.y,
        lightZ: lights[0].position.z,
        lightBrightness: lights[0].intensity
    }

    // var datOptions = new Options();
    var gui = new dat.GUI();
    
    var guiViewControl = gui.addFolder('View Control');
    guiViewControl.open();
    guiViewControl.add(datOptions, 'removeGrids');
    guiViewControl.add(viewSettings, 'cameraX').min(-50).max(50).step(0.1);
    guiViewControl.add(viewSettings, 'cameraY').min(-50).max(50).step(0.1).listen();
    guiViewControl.add(viewSettings, 'cameraZ').min(-70).max(70).step(0.1).listen();
    guiViewControl.add(viewSettings, 'modelX').min(-50).max(50).step(0.1);
    guiViewControl.add(viewSettings, 'modelY').min(-50).max(50).step(0.1);
    guiViewControl.add(viewSettings, 'modelZ').min(-50).max(50).step(0.1);
    guiViewControl.add(viewSettings, 'modelRotX').min(-5).max(5).step(0.001);
    guiViewControl.add(viewSettings, 'modelRotY').min(-5).max(5).step(0.001).listen();
    guiViewControl.add(viewSettings, 'modelRotZ').min(-5).max(5).step(0.001);
    
    var guiLightControl = gui.addFolder('Light Control');
    guiLightControl.add(datOptions, 'lightX', -150, 150).listen();
    guiLightControl.add(datOptions, 'lightY', -150, 150).listen();
    guiLightControl.add(datOptions, 'lightZ', -150, 150).listen();
    guiLightControl.add(datOptions, 'lightBrightness', 0, 2).listen();
    guiLightControl.add(datOptions, 'selectLight', [0,1,2,3]).onChange(function(){
        datOptions.lightX = lights[datOptions.selectLight].position.x;
        datOptions.lightY = lights[datOptions.selectLight].position.y;
        datOptions.lightZ = lights[datOptions.selectLight].position.z;
        datOptions.lightBrightness = lights[datOptions.selectLight].intensity;
    });
    
    var guiOutput = gui.addFolder('Output');
    guiOutput.open();
    guiOutput.add(datOptions, 'printPOI');
    guiOutput.add(datOptions, 'printLight');
    guiOutput.add(datOptions, 'getPNG');
    guiOutput.add(datOptions, 'getPNGThumb');

    // light control
    setInterval( function () {
        lights[datOptions.selectLight].position.set(datOptions.lightX,datOptions.lightY,datOptions.lightZ);
        lights[datOptions.selectLight].intensity = datOptions.lightBrightness;
    }, 1000 / 10 );
}