var gulp = require('gulp'); 

var concat = require('gulp-concat');
var rename = require('gulp-rename');
var livereload = require('gulp-livereload');

var coffee = require('gulp-coffee');
var uglify = require('gulp-uglify');

var compass = require('gulp-compass');
var minifyCSS = require('gulp-minify-css');




gulp.task('js', function() {
    return gulp.src('js/src/*.js')
        .pipe(concat('script.min.js'))
        .pipe(uglify())
        .pipe(gulp.dest('js'))
        .pipe(livereload());
});


gulp.task('compass', function() {
    return gulp.src('scss/*.scss')
        .pipe(compass({
            css: 'css',
            sass: 'scss'
        }))
        .on('error', function(err) {
            console.log(err.message);
        })
        .pipe(minifyCSS())
        .pipe(gulp.dest('css'))
        .pipe(livereload());
});


gulp.task('all', function() {
    return gulp.src('scss/*.scss').pipe(livereload());
});



gulp.task('watch', function() {
    gulp.watch('js/src/*.js', ['js']);
    gulp.watch('scss/*.scss', ['compass']);
    gulp.watch('html/**', ['all']);
    gulp.watch('ts/**', ['all']);
});


    
gulp.task('default', ['js', 'compass', 'watch']);









