﻿$(function () {

    var width = 320;
    var height = 240;

    var markerWidth = 10;
    var parameters = new FLARParam(width, height);
    var detector = new FLARMultiIdMarkerDetector(parameters, markerWidth);


    var renderer = new THREE.WebGLRenderer();
    renderer.setSize(width * 2, height * 2);
    $('#threeCanvas').append(renderer.domElement);

    var scene = new THREE.Scene();

    var camera = new THREE.Camera();
    camera.setJsArMatrix(parameters);
    scene.add(camera);


    var light = new THREE.DirectionalLight(0xffffff);
	light.position.set(0, 5, 5);
    scene.add(light);



    
    var obj3D = new THREE.Object3D();

    //
    //
    // add Model
    //
    //



    // INPUT CAPTURE
    //
    var inputCapture = $('#inputCapture')[0];    
    var inputCamera = new THREE.Camera();
    var inputScene = new THREE.Scene();
    var inputTexture = new THREE.Texture(inputCapture);
    var inputPlane = new THREE.Mesh(new THREE.PlaneGeometry(2, 2, 0), new THREE.MeshBasicMaterial({ map: inputTexture }));
    inputPlane.material.depthTest = false;
    inputPlane.material.depthWrite = false;
    inputScene.add(inputPlane);
    inputScene.add(inputCamera);

    var imageReader = new NyARRgbRaster_Canvas2D(inputCapture);
    var resultMatrix = new NyARTransMatResult();

    // WEBCAM INPUT
    //
    window.URL = window.URL || window.webkitURL;
    navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia || function (type, success, error) { error(); };
    var input;
    navigator.getUserMedia({ 'video': true }, function (stream) {
    	input = $('#inputStream')[0];
    	input.src = window.URL.createObjectURL(stream);

    	//
    	// start capturing - detecting - mapping - rendering
    	// 
    });
    


    // RENDER LOOP
    //
    function loop() {
        inputCapture.getContext('2d').drawImage(input, 0, 0, width, height);

        inputCapture.changed = true;
        inputTexture.needsUpdate = true;

        if (detector.detectMarkerLite(imageReader, 128) > 0) {
            detector.getTransformMatrix(0, resultMatrix);

            obj3D.setJsArMatrix(resultMatrix);
            obj3D.matrixWorldNeedsUpdate = true;
        }

        renderer.autoClear = false;
        renderer.clear();
        renderer.render(inputScene, inputCamera);
        renderer.render(scene, camera);
    }
})