// GLOABLS
var THE_IDEA_SECTIONS = [];
var SUBNAV_ELEMENT;
var NEXT_ELEMENT;






// HELPER

function scrollTo(element, to, duration) {
    var start = element.scrollTop,
        change = to - start,
        currentTime = 0,
        increment = 20;

    var animateScroll = function(){        
        currentTime += increment;
        var val = Math.easeInOutQuad(currentTime, start, change, duration);                        
        element.scrollTop = val; 
        if(currentTime < duration) {
            setTimeout(animateScroll, increment);
        }
    };
    animateScroll();
}
Math.easeInOutQuad = function (t, b, c, d) {
    t /= d/2;
    if (t < 1) return c/2*t*t + b;
    t--;
    return -c/2 * (t*(t-2) - 1) + b;
};

// end of HELPER



function initTheIdeaSections() {

	function TheIdeaSection(sectionElement,subnavAElement) {
		var _sectionElement = sectionElement;
		var _subnavAElement = subnavAElement;
		var _nextElement = _sectionElement.querySelector('a.next');
		var _textColor = sectionElement.classList.contains('white') ? 'white' : 'black';
		var _isActive = false;
		THE_IDEA_SECTIONS.push(this);

		function changeSubnav() {
			if (_isActive) {
				SUBNAV_ELEMENT.dataset.color = _textColor;
				_subnavAElement.classList.add('active');
			} else {
				_subnavAElement.classList.remove('active');
			}
		} // end of changeSubnav

		function animateOnScroll () {

			var scrollY = window.scrollY - _sectionElement.offsetTop;
			if (scrollY > - window.innerHeight/2 && scrollY < _sectionElement.offsetHeight - window.innerHeight/2) {
				_isActive = true;
				changeSubnav();
			} else {
				_isActive = false;
				changeSubnav();
			}

			if (scrollY < _sectionElement.offsetHeight && scrollY > -_sectionElement.offsetHeight) {
				var translateImg = Math.round(scrollY * 0.1);
				if (scrollY < 0) {
					var opacityH1 = 1+(0 + scrollY)*0.004;
					var opacityP = 1+(0 + scrollY)*0.005;
					var translateXH1 = -scrollY*0.4;
					var translateXP = -scrollY*0.55;
				}
				window.webkitRequestAnimationFrame(function(){
					_sectionElement.querySelector('.text-box h1').style.opacity = opacityH1;
					_sectionElement.querySelector('.text-box p').style.opacity = opacityP;
					_sectionElement.querySelector('.text-box h1').style.webkitTransform = 'translate3d(0,'+translateXH1+'px,0)';
					_sectionElement.querySelector('.text-box p').style.webkitTransform = 'translate3d(0,'+translateXP+'px,0)';
					_sectionElement.querySelector('.background-image').style.webkitTransform = 'translate3d(0,'+translateImg+'px,0)';
				});
			}

		} // animateOnScroll()

		changeSubnav();

		_subnavAElement.addEventListener('click',function(e){
			e.preventDefault();
			scrollTo(document.body,_sectionElement.offsetTop,700);
		});
		if (_nextElement) {
			_nextElement.addEventListener('click',function(e){
				e.preventDefault();
				scrollTo(document.body,_sectionElement.offsetTop+_sectionElement.offsetHeight,700);
			});
		}

	    Object.defineProperty(this, 'animateOnScroll', {
	        get: function(){
	        	animateOnScroll();
	        }
	    });
	} // end of TheIdeaSection();


	var the_ideaElememt = document.getElementById('the_idea');
	SUBNAV_ELEMENT = the_ideaElememt.querySelector('.subnav');
	NEXT_ELEMENT = the_ideaElememt.querySelector('a.next');
	var theIdeaSectionElements = the_ideaElememt.querySelectorAll('section');
	var theIdeaSubnavAElemens = SUBNAV_ELEMENT.querySelectorAll('a');

	var i = theIdeaSectionElements.length;
	while(i--) {
		new TheIdeaSection(theIdeaSectionElements[i],theIdeaSubnavAElemens[i]);
	}

	setTimeout(function(){
		SUBNAV_ELEMENT.style.marginTop = -SUBNAV_ELEMENT.offsetHeight/2+'px';
		animateTheIdeaSections();
	},100);

	NEXT_ELEMENT.addEventListener('click',function(){

	});

} // end of initTheIdeaSection();


function animateTheIdeaSections() {
	if (THE_IDEA_SECTIONS) {
		var i = THE_IDEA_SECTIONS.length;
		while (i--) {
			THE_IDEA_SECTIONS[i].animateOnScroll;
		}
	}
} // end of animateTheIdeaSections()






// init

initTheIdeaSections();


window.addEventListener('scroll',function(e){
	animateTheIdeaSections();
	console.log(e);
});


